# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

import time

from scenes.common.t_psel import TPsel
from scenes.cruiser.t_cruiser import TCruiser
from kiki.util.log import file_logger as logger
from scenes.friend_mypage.t_mypage import TMypage
from scenes.home_menu.t_home_menu import THomeMenu
from sequences.SwkbdInputter import SwkbdInputter


def link_NA_seq(driver, login_id, login_pass, save_basic_auth_flg=False, id=0):
    # ログインアプレット( ログイン / 新規作成 )で ログイン を選んだ状態からスタート
    _scene = TCruiser(driver)
    if not _scene.input_user_authentication(save_flg=save_basic_auth_flg):
        logger.info("ユーザー認証 での操作に問題がありました。")
        return False

    if not _scene.is_available_NA_login_page():
        logger.info("アカウントログインページ へ遷移しませんでした。")
        return False

    driver.controllers[id].push("A", ms_after=1000)

    if not _scene.is_available_input_login_info():
        logger.info("ニンテンドーアカウントと連携 ページへ遷移しませんでした。")
        return False

    driver.controllers[id].push("A", ms_after=1000)
    _si = SwkbdInputter(driver, strings=login_id)
    _si.run()

    _si = SwkbdInputter(driver, strings=login_pass)
    _si.run()

    _scene = TPsel(driver)
    if not _scene.check_complete_linked_NA():
        logger.info("ニンテンドーアカウントの紐付に失敗しています。")
        return False

    # LongRun は HOMEボタン押下で抜ける。
    driver.controllers[id].push("HOME", ms_after=1000)
    return True


def unlink_NA_seq(driver, id=0):
    # 本体設定でユーザーを選択したところからスタート
    driver.controllers[id].push("DOWN", ms_press=3000, ms_after=1000)
    driver.controllers[id].push("UP", ms_after=1000)
    driver.controllers[id].push("A", ms_after=1000)

    driver.controllers[id].push("UP", ms_after=1000)
    driver.controllers[id].push("A", ms_after=1000)

    time.sleep(4)
    driver.controllers[id].push("UP", ms_after=1000)
    driver.controllers[id].push("A", ms_after=1000)

    # 「連携を解除しました。」
    _scene = TPsel(driver)
    if not _scene.check_complete_unlinked_NA():
        logger.info("ニンテンドーアカウントの紐付解除に失敗しています。")
        return False

    # HOMEmenuへ戻っておく
    driver.controllers[id].push("HOME", ms_after=1000)
    return True

def is_NA_linked_user_seq(driver, user_index=0, id=0):
    # HOMEメニューから開始すること
    driver.controllers[id].push("HOME", ms_after=1000)
    driver.controllers[id].push("UP", ms_after=1000)

    # 左から user_index 番目のユーザーアイコンを選ぶ
    for i in range(user_index):
        driver.controllers[id].push("RIGHT", ms_after=500)
    driver.controllers[id].push("A", ms_after=1000)

    _scene = TMypage(driver)
    return _scene.is_NA_linked_user()

