# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

import os

import time
from abc import ABCMeta, abstractmethod

import subprocess

from params.winpos import WIN_POS
from res.res_path import RES_PATH
from kiki.util.log import file_logger as logger
from sequences.SwkbdInputter import SwkbdInputter


_ICON_IMAGE_PATH = RES_PATH + "/base_scene/"

class TBaseScene(object):
    __metaclass__ = ABCMeta

    def __init__(self, hac_driver):
        self.driver = hac_driver

    @abstractmethod
    def is_available(self):
        pass

    def input_user_authentication(self, save_flg=False):
        image = _ICON_IMAGE_PATH + "ss_user_authentication_JP.png"
        image2 = _ICON_IMAGE_PATH + "basic_auth_already_input.png"
        for i in range(60):
            if self.driver.screen.detect_object_with_image(image) is not None:
                time.sleep(2)
                if self.driver.screen.detect_object_with_image(image2) is not None:
                    # 保存済みの情報がすでに入力されている状態→ログイン選択のみ
                    self.driver.controllers[0].push("A", ms_after=1000)
                    return True
                break
            else:
                time.sleep(1)
        else:
            logger.info("ユーザー認証( Basic認証 )画面 へ遷移しませんでした。")
            return False

        self.driver.controllers[0].push("A", ms_after=1000)
        _si = SwkbdInputter(self.driver, strings="nintendo")
        _si.run()

        self.driver.controllers[0].push("A", ms_after=1000)
        _si = SwkbdInputter(self.driver, strings="")
        _si.run()

        time.sleep(3)
        self.driver.controllers[0].push("A", ms_after=1000)

        # ユーザー名/パスワードの保存
        # 「このサイトでは常に保存しない」は一先ず対応してないです
        if save_flg:
            self.driver.controllers[0].push("RIGHT", ms_after=1000)
        self.driver.controllers[0].push("A", ms_after=1000) # いまはしない 選択

        return True

