# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from scenes.common.swkbd import Swkbd

from kiki.util.log import file_logger as logger



class MiiNicknameEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiNicknameEditor, self).__init__(driver)
        self.swkbd = Swkbd(driver)
        self.driver = driver

    def set_nickname_settings(self,nickname,language, logstore):
        if nickname is not "default":
            self.swkbd.swkbd_initialize_imputmode()
            for i in range(12): # 2回余分に押させます。
                self.driver.screen.touch(0,x=1170,y=365,ms_after=200)
            self.swkbd.swkbd_input_str(nickname,language, logstore)
            self.swkbd.swkbd_input_enter()
        else:
            self.back_to_edit_menu()

