# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from testcases.examples.utility import touch_bar_point_percent_of
from kiki.util.log import file_logger as logger

class MiiMustacheEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiMustacheEditor, self).__init__(driver)

    def select_mustache_parts(self,id):
        id_pos = {
            0:[280,230],
            1:[380,230],
            2:[480,230],
            3:[280,330],
            4:[380,330],
            5:[480,330],
        }
        self.driver.screen.touch(0,x= 210,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)

    def select_mustache_placement(self,placement_info):
        # くちひげの配置の設定値を上から順にリストでもらい、該当する引数のレベル（パーセンテージ）の位置をタッチする
        #percentage = argument / argument_num
        #touch_bar_point_percent_of(self.driver,start_x=252,start_y=215,angle=0,bar_length=256,percentage=percentage)
        self.driver.screen.touch(0,x= 380,y= 85, ms_after=500)

        arg = (placement_info)
        max_arg = [16,8]
        percentages = []
        for n in range(len(arg)):
            if arg[n] is not None :
                percentages.append(arg[n] / max_arg[n])
            else:
                percentages.append(arg[n])

        bar_y_pos =300
        for x in percentages:
            if x is not None:
                touch_bar_point_percent_of(self.driver,start_x=252,start_y=bar_y_pos,angle=0,bar_length=256,percentage=x)
            bar_y_pos += 80


    def select_beard_parts(self,id):
        id_pos = {
            0:[280,490],
            1:[380,490],
            2:[480,490],
            3:[280,590],
            4:[380,590],
            5:[480,590],
        }
        self.driver.screen.touch(0,x= 210,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)


    def set_mustache_settings(self,mustache_parts_id,beard_parts_id,mustache_pos,mustache_size,mustache_color_id):
        # placement の情報をリスト化する処理をここで入れたい
        mustache_placement = [mustache_pos,mustache_size]
        if mustache_parts_id is not None :self.select_mustache_parts(mustache_parts_id)
        if beard_parts_id is not None:self.select_beard_parts(beard_parts_id)
        if mustache_parts_id == 0 and beard_parts_id == 0:
            self.back_to_edit_menu()

        elif mustache_parts_id == 0 and beard_parts_id != 0:
            if mustache_color_id is not None :self.select_color_of_parts(mustache_color_id)
            self.back_to_edit_menu()

        else:
            self.select_mustache_placement(mustache_placement)
            if mustache_color_id is not None :self.select_color_of_parts(mustache_color_id)
            self.back_to_edit_menu()
