# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from params.winpos import WIN_POS
from res.res_path import RES_PATH

from kiki.util.log import file_logger as logger
from scenes.base_scene import BaseScene

_ICON_IMAGE_PATH = RES_PATH + "/main_setting/"

class MainSetting(BaseScene):
    def __init__(self, driver):
        super(MainSetting, self).__init__(driver)

    def is_available(self):
        icon_name_list = [
            "main_setting.png",
            "main_setting_USen.png",
            "main_setting_EUen.png"
        ]

        for icon_name in icon_name_list:
            main_setting_icon = _ICON_IMAGE_PATH + icon_name
            if self.driver.screen.detect_object_with_image(main_setting_icon) is not None:
                return True
        return False


    def is_available_from_log(self,logstore):
        #直前のログを確認して本体設定にいるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<qlaunch\>.*\[Setting\]"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def select_left_menu(self, name, logstore):
        # select_left_menu_by_keys がボタン操作での実装なので、
        # ボタン操作・タッチ操作のどちらでも良い場合は、select_left_menu_by_keys を使用して下さい。
        menu_dict = {
            "サポート": ["set_menu_support.png", "set_selected_menu_support.png",
                     "set_menu_support_USen.png", "set_selected_menu_support_USen.png",
                     "set_menu_support_EUen.png", "set_selected_menu_support_EUen.png"],
            "機内モード": ["set_menu_flight_mode.png", "set_selected_menu_flight_mode.png",
                      "set_menu_flight_mode_USen.png", "set_selected_menu_flight_mode_USen.png",
                      "set_menu_flight_mode_EUen.png", "set_selected_menu_flight_mode_EUen.png"],
            "画面の明るさ": ["set_menu_display.png", "set_selected_menu_display.png",
                       "set_menu_display_USen.png", "set_selected_menu_display_USen.png",
                       "set_menu_display_EUen.png", "set_selected_menu_display_EUen.png"],
            "ロック": ["set_menu_lock.png", "set_selected_menu_lock.png",
                    "set_menu_lock_USen.png", "set_selected_menu_lock_USen.png",
                    "set_menu_lock_EUen.png", "set_selected_menu_lock_EUen.png"],
            "保護者による使用制限": ["set_menu_child_lock.png", "set_selected_menu_child_lock.png",
                           "set_menu_child_lock_USen.png", "set_selected_menu_child_lock_USen.png",
                           "set_menu_child_lock_EUen.png", "set_selected_menu_child_lock_EUen.png"],
            "インターネット": ["set_menu_internet.png", "set_selected_menu_internet.png",
                        "set_menu_internet_USen.png", "set_selected_menu_internet_USen.png",
                        "set_menu_internet_EUen.png", "set_selected_menu_internet_EUen.png"],
            "データ管理": ["set_menu_data_mng.png", "set_selected_menu_data_mng.png",
                      "set_menu_data_mng_USen.png", "set_selected_menu_data_mng_USen.png",
                      "set_menu_data_mng_EUen.png", "set_selected_menu_data_mng_EUen.png"],
            "ユーザー": ["set_menu_user.png", "set_selected_menu_user.png",
                     "set_menu_user_USen.png", "set_selected_menu_user_USen.png",
                     "set_menu_user_EUen.png", "set_selected_menu_user_EUen.png"],
            "Mii": ["set_menu_Mii.png", "set_selected_menu_Mii.png",
                    "set_menu_Mii_USen.png", "set_selected_menu_Mii_USen.png",
                    "set_menu_Mii_EUen.png", "set_selected_menu_Mii_EUen.png"],
            "amiibo": ["set_menu_amiibo.png", "set_selected_menu_amiibo.png",
                       "set_menu_amiibo_USen.png", "set_selected_menu_amiibo_USen.png",
                       "set_menu_amiibo_EUen.png", "set_selected_menu_amiibo_EUen.png"],
            "テーマ": ["set_menu_theme.png", "set_selected_menu_theme.png",
                    "set_menu_theme_USen.png", "set_selected_menu_theme_USen.png",
                    "set_menu_theme_EUen.png", "set_selected_menu_theme_EUen.png"],
            "通知": ["set_menu_notice.png", "set_selected_menu_notice.png",
                   "set_menu_notice_USen.png", "set_selected_menu_notice_USen.png",
                   "set_menu_notice_EUen.png", "set_selected_menu_notice_EUen.png"],
            "スリープ": ["set_menu_sleep.png", "set_selected_menu_sleep.png",
                     "set_menu_sleep_USen.png", "set_selected_menu_sleep_USen.png",
                     "set_menu_sleep_EUen.png", "set_selected_menu_sleep_EUen.png"],
            "コントローラーとセンサー": ["set_menu_controller.png", "set_selected_menu_controller.png",
                             "set_menu_controller_USen.png", "set_selected_menu_controller_USen.png",
                             "set_menu_controller_EUen.png", "set_selected_menu_controller_EUen.png"],
            "テレビ出力": ["set_menu_TV_output.png", "set_selected_menu_TV_output.png",
                      "set_menu_TV_output_USen.png", "set_selected_menu_TV_output_USen.png",
                      "set_menu_TV_output_EUen.png", "set_selected_menu_TV_output_EUen.png"],
            "本体": ["set_menu_system.png", "set_selected_menu_system.png",
                  "set_menu_system_USen.png", "set_selected_menu_system_USen.png",
                  "set_menu_system_EUen.png", "set_selected_menu_system_EUen.png"]
        }

        img_name_list = menu_dict[name]
        logger.info("設定画面：左側のメニューより" + name + "を選択します。")
        integrity_result = False
        print("name: " + name)
        if name == "機内モード":
            print("機内モードの操作")
            # logstore.move_pointer_ms_before(10000)
            logstore.curr_pointer -= 10
            integrity_result = self.selected_left_menu_integrity_check(name, logstore)
            return integrity_result
        for i in range(15): # とりあえず15回までスクロールで探す
            for img_name in img_name_list:
                icon = _ICON_IMAGE_PATH + img_name
                result = self.driver.screen.detect_object_with_image(icon)
                if result is not None:
                    logstore.move_pointer_newest()
                    self.driver.screen.touch(0, result[0] + 10, result[1] + 10, ms_after=100)
                    integrity_result = self.selected_left_menu_integrity_check(name, logstore)
                    time.sleep(1)
                    return integrity_result
            else:
                self.driver.screen.drag(0, 40, 635, 40, 550, ms_after=100)

        return integrity_result

    def select_left_menu_by_keys(self, name, logstore):
        menu_dict = {
            "サポート": 0,
            "機内モード": 1,
            "画面の明るさ": 2,
            "ロック": 3,
            "保護者による使用制限": 4,
            "インターネット": 5,
            "データ管理": 6,
            "ユーザー": 7,
            "Mii": 8,
            "amiibo": 9,
            "テーマ": 10,
            "通知": 11,
            "スリープ": 12,
            "コントローラーとセンサー": 13,
            "テレビ出力": 14,
            "本体": 15
        }

        logger.info("設定画面：左側のメニューより" + name + "を選択します。")

        # サポートの場合のみ
        if name == "サポート":
            logstore.move_pointer_newest()

        # カーソル位置を初期化(サポートへ)
        self.driver.controllers[0].push("UP", ms_press=2000, ms_after=500)

        # サポート以外
        if name != "サポート":
            key_down_num = menu_dict[name]
            for i in range(key_down_num):
                if i == key_down_num - 1:
                    logstore.move_pointer_newest()
                self.driver.controllers[0].push("DOWN", ms_after=300)

        # 決定前にログで整合性確認
        integrity_result = self.selected_left_menu_integrity_check(name, logstore)
        if integrity_result:
            self.driver.controllers[0].push("A", ms_after=500)
        return integrity_result


    def selected_left_menu_integrity_check(self, name, logstore):
        reg_str_dict = {
            "サポート": "\<qlaunch\>.* SetCntSup appendChild to N_CntPosNext",
            "機内モード": "\<qlaunch\>.* SetCntFlightMode appendChild to N_CntPosNext",
            "画面の明るさ": "\<qlaunch\>.* SetCntDisplay appendChild to N_CntPosNext",
            "ロック": "\<qlaunch\>.* SetCntLock appendChild to N_CntPosNext",
            "保護者による使用制限": "\<qlaunch\>.* SetCntChild appendChild to N_CntPosNext",
            "インターネット": "\<qlaunch\>.* SetCntNet appendChild to N_CntPosNext",
            "データ管理": "\<qlaunch\>.* SetCntDataMng appendChild to N_CntPosNext",
            "ユーザー": "\<qlaunch\>.* SetCntPlayer appendChild to N_CntPosNext",
            "Mii": "\<qlaunch\>.* SetCntMii appendChild to N_CntPosNext",
            "amiibo": "\<qlaunch\>.* SetCntAmiibo appendChild to N_CntPosNext",
            "テーマ": "\<qlaunch\>.* SetCntTheme appendChild to N_CntPosNext",
            "通知": "\<qlaunch\>.* SetCntNtf appendChild to N_CntPosNext",
            "スリープ": "\<qlaunch\>.* SetCntSleep appendChild to N_CntPosNext",
            "コントローラーとセンサー": "\<qlaunch\>.* SetCntController appendChild to N_CntPosNext",
            "テレビ出力": "\<qlaunch\>.* SetCntTv appendChild to N_CntPosNext",
            "本体": "\<qlaunch\>.* SetCntHardware appendChild to N_CntPosNext"
        }

        reg_str = reg_str_dict[name]

        #直前のログを確認して name の画面にいるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str=reg_str, ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def select_hardware_menu(self, name, touch_num=1):
        # 要3リージョン対応
        # [2.0.0]本体バッテリー残帳の％表示 / ソフトの自動更新 / ゲームニュースを受け取る(要NA連携) が追加
        menu_dict = {
            "本体の更新": ["set_btn_update.png",
                            "set_btn_update_US.png",
                            "set_btn_update_EU.png"],
            "本体のニックネーム": ["set_btn_nickname_jp.png",
                                     "set_btn_nickname_US.png",
                                     "set_btn_nickname_EU.png"],
            "言語": ["set_btn_lang_jp.png",
                      "set_btn_lang_US.png",
                      "set_btn_lang_EU.png",
                      "set_btn_lang_fr.png"],
            "地域": ["set_btn_region_jp.png",
                      "set_btn_region_US.png",
                      "set_btn_region_EU.png",
                      "set_btn_region_fr.png"],
            "日付と時刻": ["set_btn_date.png",
                            "set_btn_date_US.png",
                            "set_btn_date_EU.png",
                            "set_btn_date_fr.png"],
            "本体バッテリー残量の％表示": ["set_btn_battery_display_jp.png",
                                             "set_btn_battery_display_US_EU.png"], # 北米・欧州 翻訳待ち
            "サウンド": ["set_btn_sound_jp.png",
                          "set_btn_sound_US.png",
                          "set_btn_sound_EU.png"],
            "ヘッドホンを抜いたときに消音": ["set_btn_check_mute_jp.png",
                                                "set_btn_check_mute_US.png",
                                                "set_btn_check_mute_EU.png"],
            "シリアル情報": ["set_btn_serial.png",
                              "set_btn_serial_US.png",
                              "set_btn_serial_EU.png"],
            "利用規約": ["set_btn_terms_jp.png",
                          "set_btn_terms_US.png",
                          "set_btn_terms_EU.png"],
            "知的財産の表記": ["set_btn_property.png",
                                "set_btn_property_US.png",
                                "set_btn_property_EU.png"],
            "認証表示": ["set_btn_auth.png",
                          "set_btn_auth_US.png",
                          "set_btn_auth_EU.png"],
            "ソフトの自動更新": ["set_btn_check_auto_update_jp.png",
                                  "set_btn_check_auto_update_US.png",
                                  "set_btn_check_auto_update_EU.png"],
            "ゲームニュースを受け取る": ["set_btn_check_nintendo_news_jp.png",
                                           "set_btn_check_nintendo_news_US.png",
                                           "set_btn_check_nintendo_news_EU.png"],
            "初期化": ["set_btn_format.png",
                        "set_btn_format_US.png",
                        "set_btn_format_EU.png"]
        }
        # for i in range(4):
        #     self.driver.screen.swipe(0, start_x=1150, start_y=200, angle_deg=90, length=370.0,ms_after=700)

        self.driver.controllers[0].push("UP", ms_press=2000, ms_after=500)

        icon = menu_dict[name]
        # icon = self.get_imread_result_list(btn_name_list)
        for i in range(15): # とりあえず15回までスクロールで探す
            result = self.search_icon(icon)
            if result is not None:
                for i in range(touch_num):
                    self.driver.screen.touch(0, result[0] + 10, result[1] + 10, ms_after=800)
                return
            else:
                self.driver.screen.drag(0, 460, 630, 460, 400, ms_after=1000)


    def operate_sys_update(self):
        # 0816a でできる操作は、下記3種類？
        # ・ネット接続有→本体更新無
        # ・ネット接続無→ネット設定する→ネット接続完了OKで送る→本体更新無
        # ・ネット接続無→ネット設定しない
        # ※今のところ未使用
        icon_image_path_list = [
            _ICON_IMAGE_PATH + "set_err_btn.png", # 本体更新がなかった時のボタン
            _ICON_IMAGE_PATH + "set_err_btn1.png", # set_err_btnの代わり(0819のロム)
            _ICON_IMAGE_PATH + "set_err_btn2.png", # set_err_btnの代わり(0819のロム)
            _ICON_IMAGE_PATH + "set_dialog_ok_btn.png" # ネット設定がないときのダイアログ、OKボタン
        ]

        icon_image_list = []
        for icon_image in icon_image_path_list:
            icon_image_list.append(icon_image)
        x_pos, y_pos = self._search_icon_from_image_list(icon_image_list)
        self.driver.screen.touch(0, x_pos + 10, y_pos + 10, ms_after=500)
        time.sleep(5)

        icon = _ICON_IMAGE_PATH + "icon_internet_setting.png"
        if self.driver.screen.detect_object_with_image(icon) is not None:
            self.driver.screen.touch(0, 100, 680, ms_after=500)

    def search_icon(self, name, threshold=0.8, shows_result=False):
        if type(name) == list:
            for image_name in name:
                icon_image = _ICON_IMAGE_PATH + image_name
                icon = icon_image
                result = self.driver.screen.detect_object_with_image(icon, threshold=threshold, shows_result=shows_result)
                if result is not None:
                    return result[0], result[1]
            return None
        else:
            icon_image = _ICON_IMAGE_PATH + name
            icon = icon_image
            result = self.driver.screen.detect_object_with_image(icon, threshold=threshold, shows_result=shows_result)
            if result is not None:
                return result[0], result[1]
            else:
                return None

    def get_imread_result_list(self, icon_path_list):
        result_list = []
        for icon_path in icon_path_list:
            icon_image = _ICON_IMAGE_PATH + icon_path
            result_list.append(icon_image)

        return result_list

    def wait_until_detect_object(self, name, threshold=0.8, limit_count=60, shows_result=False):
        icon = []
        if type(name) == list:
            icon = self.get_imread_result_list(name)
        else:
            icon_image = _ICON_IMAGE_PATH + name
            icon.append(icon_image)

        if self.driver.screen.wait_until_detect_object(icon, threshold=threshold, limit_count=limit_count, shows_result=shows_result) is not None:
            return True
        else:
            return False

    def change_language(self, trg_lang):
        # 変更する言語を選択し、表示されるダイアログを「次へ」で送るところまで
        # 予め言語一覧を表示した状態で呼ぶこと
        lang_dict = {"en": 0,
                     "fr": 1,
                     "de": 2,
                     "es": 3,
                     "it": 4,
                     "nl": 5,
                     "pt": 6,
                     "ru": 7,
                     "ja": 8 }

        self.driver.controllers[0].push("UP", ms_press=1000, ms_after=300)
        for i in range(lang_dict[trg_lang]):
            self.driver.controllers[0].push("DOWN", ms_after=300)
        self.driver.controllers[0].push("A", ms_after=1000)

        self.driver.controllers[0].push("A") # 再起動が始まる

    def change_region(self, trg_region):
        # 変更する地域を選択し、表示されるダイアログを「次へ」で送るところまで
        # 予め地域一覧を表示した状態で呼ぶこと
        region_dict = {"JP": 0,
                       "US": 1,
                       "EU": 2,
                       "AU": 3 }

        self.driver.controllers[0].push("UP", ms_press=1000, ms_after=300)
        for i in range(region_dict[trg_region]):
            self.driver.controllers[0].push("DOWN", ms_after=300)
        self.driver.controllers[0].push("A", ms_after=1000)

        self.driver.controllers[0].push("A", ms_after=1000)

    def wait_visible_confirm_btn_in_del_important(self):
        icon_image = "set_icon_caution.png"
        self.wait_until_detect_object(icon_image, limit_count=30)
        time.sleep(3)

    def select_restart_button_at_change_region(self, trg_region):
        # 変更する地域を選択して、重要な情報画面まで遷移した後にこの関数を呼べば、
        # 「再起動する」を選択します。
        # JP/US 同意のチェックボックス有
        # EU/AU 同意のチェックボックス無
        check_box_presence_dict = { "JP": True,
                                    "US": True,
                                    "EU": False,
                                    "AU": False }
        for i in range(3):
            self.driver.controllers[0].push("UP")

        if check_box_presence_dict[trg_region]:
            # 同意のチェックボックス有
            for i in range(2):
                # 1回目：チェックボックスの選択
                # 2回目：「再起動する」の選択
                self.driver.controllers[0].push("DOWN", ms_after=500)
                self.driver.controllers[0].push("A", ms_after=500)
        else:
            # 同意のチェックボックス無
            self.driver.controllers[0].push("DOWN", ms_after=500)
            self.driver.controllers[0].push("A")


if __name__ == "__main__":
    logger.info("program start")
    logger.info("============================================")

    with factory(*WIN_POS, capture=CaptureType.DirectShow) as _driver:
        _scene = MainSetting(_driver)
        _scene.wait_visible_confirm_btn_in_del_important()
        print("end")