# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


from params.winpos import WIN_POS
from scenes.base_scene import BaseScene
from res.res_path import RES_PATH
from kiki.util.log import file_logger as logger
import time



_ICON_IMAGE_PATH = RES_PATH + "/entrance/"

class Entrance(BaseScene):
    def __init__(self, driver):
        super(Entrance, self).__init__(driver)
        self.driver = driver

    def is_available(self):
        icon_image_list = [
                           _ICON_IMAGE_PATH + "ss_entrance_anchor.PNG",
                            ]

        for icon_image in icon_image_list:
            if self.driver.screen.detect_object_with_image(icon_image) is not None:
                return True
        else:
            return False

    def is_available_from_log(self,logstore, is_reverse=False):
        #直前のログを確認してエントランスにいるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\[scene::SceneEntrance\].*exeTop"
                                         , ms_timeout=10000, is_reverse=is_reverse)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def leave_entrance(self):
        time.sleep(3)
        self.driver.screen.touch(0, 830, 360, ms_after=800)
        for i in range(3):
            self.driver.screen.touch(0, 640, 360, ms_after=500)
            # self.driver.controllers[0].push("A",ms_after=800)
        """
        self.driver.screen.touch(0,x=825, y=360, ms_after=800)
        while True:
            image = [_ICON_IMAGE_PATH + "ss_lock_release_circle.PNG"]
            result_pos = self._search_icon_from_image_list(icon_image_list=image, threshold=0.80, shows_result=False)
            if result_pos is not None:
                print(result_pos)
                self.driver.screen.touch(0,x=result_pos[0], y=result_pos[1], ms_after=500)
            else:
                break
                """

    def open_nth_news_in_list(self,n):
        #3つのニュースのうち上から順番にnumで指定した座標をタッチする n=0から
        self.driver.screen.touch(0,x=180, y=220 + 170*n , ms_after=500)
        for n in range(3):
            self.driver.screen.touch(0, 640, 360, ms_after=500)
            # self.driver.controllers[0].push("A",ms_after=800)

        """
        while True:
            image = [_ICON_IMAGE_PATH + "ss_lock_release_circle.PNG"]
            result_pos = self._search_icon_from_image_list(icon_image_list=image, threshold=0.80, shows_result=False)
            if result_pos is not None:
                print(result_pos)
                self.driver.screen.touch(0,x=result_pos[0], y=result_pos[1], ms_after=500)
            else:
                break
            """
