# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


from params.winpos import WIN_POS
from scenes.base_scene import BaseScene
from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH


_ICON_IMAGE_PATH = RES_PATH + "/common/" # psel って場所作ったほうがいい？


class PlayerSelect(BaseScene):
    def __init__(self, driver):
        super(PlayerSelect, self).__init__(driver)

    def is_available(self):
        icon_name_list = [
            "ss_psel_select_user_JP.png",
            "ss_psel_select_user_US_EU.png"
        ]

        for icon_name in icon_name_list:
            icon = _ICON_IMAGE_PATH + icon_name
            if self.driver.screen.detect_object_with_image(icon) is not None:
                return True
        return False

    def is_available_from_log(self,logstore, ms_timeout=10000):
        #直前のログを確認してpselに来てるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<playerSelect\>.*scene.*createScene\(\).*"
                                         , ms_timeout=ms_timeout)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def search_icon(self, name, threshold=0.8, shows_result=False):
        if type(name) == list:
            for image_name in name:
                icon_image = _ICON_IMAGE_PATH + image_name
                icon = icon_image
                result = self.driver.screen.detect_object_with_image(icon, threshold=threshold, shows_result=shows_result)
                if result is not None:
                    return result[0], result[1]
            return None
        else:
            icon_image = _ICON_IMAGE_PATH + name
            icon = icon_image
            result = self.driver.screen.detect_object_with_image(icon, threshold=threshold, shows_result=shows_result)
            if result is not None:
                return result[0], result[1]
            else:
                return None

    def has_been_closed(self,logstore):
        #直前のログを確認してクイック設定#が閉じたかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<overlayDisp\>.*Ducking Stop : cTypeMiniMenu"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def get_imread_result_list(self, icon_path_list):
        result_list = []
        for icon_path in icon_path_list:
            icon_image = _ICON_IMAGE_PATH + icon_path
            result_list.append(icon_image)

        return result_list

    def wait_until_detect_object(self, name, threshold=0.8, limit_count=60, shows_result=False):
        icon = []
        if type(name) == list:
            icon = self.get_imread_result_list(name)
        else:
            icon_image = _ICON_IMAGE_PATH + name
            icon.append(icon_image)

        if self.driver.screen.wait_until_detect_object(icon, threshold=threshold, limit_count=limit_count, shows_result=shows_result) is not None:
            return True
        else:
            return False

    def get_post_swkbd_nickname(self, logstore):
        # [3.0.0 NUP]ターゲットにしていたログが TM に出力されなくなったので使えない。

        # SWKBDで入力されたニックネームをログから取得する。
        # is_reverse=True で実行して確認後に logstore の最新へポインタを移動させる。
        logger.info("Start get_post_swkbd_nickname")
        logstore.move_pointer_newest()
        match = logstore.read_line_until(reg_str="<playerSelect>.*post-swkbd nickname:.*", ms_timeout=10000,
                                         is_reverse=True)
        logstore.move_pointer_newest()

        if match is not None:
            print(match.string)
            return match.string.split(" ")[4]
        else:
            print("matching timeout")
            return None

