﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <tchar.h>
#include "..\..\Common\testAutoTestAssistTool_Util.h"
#include "LogReaderWrapper.h"

bool LogReaderWrapper::TryLoadLibrary()
{
    auto libPath = autoTestAssistTool::util::GetSdkRootPath().append(
        "\\Tools\\AutoTestAssistTools\\Libraries\\LogReader.dll");
    m_ModuleHandle = ::LoadLibraryA(libPath.c_str());
    return (m_ModuleHandle != NULL);
}

bool LogReaderWrapper::TryLoadFunctions()
{
    if (m_ModuleHandle == NULL)
    {
        return false;
    }

    bool result = true;

    m_StartLogStoringFunction = (StartLogStoringFunction)GetProcAddress(m_ModuleHandle, "StartLogStoring");
    if (m_StartLogStoringFunction == NULL)
    {
        printf("StartLogStoring is not found\n");
        result = false;
    }

    m_GetLogLineSizeFunction = (GetLogLineSizeFunction)GetProcAddress(m_ModuleHandle, "GetLogLineSize");
    if (m_GetLogLineSizeFunction == NULL)
    {
        printf("GetLogLineSize is not found\n");
        result = false;
    }

    m_GetLogLineFunction = (GetLogLineFunction)GetProcAddress(m_ModuleHandle, "GetLogLine");
    if (m_GetLogLineFunction == NULL)
    {
        printf("GetLogLine is not found\n");
        result = false;
    }

    m_WaitForNextLineFunction = (WaitForNextLineFunction)GetProcAddress(m_ModuleHandle, "WaitForNextLine");
    if (m_WaitForNextLineFunction == NULL)
    {
        printf("WaitForNextLine is not found\n");
        result = false;
    }

    m_WaitUntilMatchedFunction = (WaitUntilMatchedFunction)GetProcAddress(m_ModuleHandle, "WaitUntilMatched");
    if (m_WaitUntilMatchedFunction == NULL)
    {
        printf("WaitUntilMatched is not found\n");
        result = false;
    }

    m_SearchFormerLogFunction = (SearchFormerLogFunction)GetProcAddress(m_ModuleHandle, "SearchFormerLog");
    if (m_SearchFormerLogFunction == NULL)
    {
        printf("SearchFormerLog is not found\n");
        result = false;
    }

    m_MoveToNewestLineFunction = (MoveToNewestLineFunction)GetProcAddress(m_ModuleHandle, "MoveToNewestLine");
    if (m_MoveToNewestLineFunction == NULL)
    {
        printf("MoveToNewestLine is not found\n");
        result = false;
    }

    m_MoveToFormerLineByTimeFunction = (MoveToFormerLineByTimeFunction)GetProcAddress(m_ModuleHandle, "MoveToFormerLineByTime");
    if (m_MoveToFormerLineByTimeFunction == NULL)
    {
        printf("MoveToFormerLineByTime is not found\n");
        result = false;
    }

    m_StopLogStoringFunction = (StopLogStoringFunction)GetProcAddress(m_ModuleHandle, "StopLogStoring");
    if (m_StopLogStoringFunction == NULL)
    {
        printf("StopLogStoring is not found\n");
        result = false;
    }

    m_MoveToNextLineFunction = (MoveToNextLineFunction)GetProcAddress(m_ModuleHandle, "MoveToNextLine");
    if (m_MoveToNextLineFunction == NULL)
    {
        printf("MoveToNextLineFunction is not foud\n");
        result = false;
    }

    m_MoveToPreviousLineFunction = (MoveToPreviousLineFunction)GetProcAddress(m_ModuleHandle, "MoveToPreviousLine");
    if (m_MoveToPreviousLineFunction == NULL)
    {
        printf("MoveToPreviousLine is not found\n");
        result = false;
    }

    return result;
}
