﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <random>
#include "HidInputerWrapper.h"

// ターゲットシリアル取得
bool GetTargetSerial(SerialNumberString* pOutSerial);

// 全コントローラー接続・解除
void ConnectAllController( hidInputer::HidInputerWrapper *wrapper );
void ReleaseAllController( hidInputer::HidInputerWrapper *wrapper );

// パラメーター生成関数
int CreateInvalidControllerId();
int CreateInvalidButton();
int CreateInvalidStick();
int CreateInvalidTouchId();
int CreateRandomSign();
float CreateDegree(bool isBigValue);
float CreatePower(bool isBigValue);

// マルチタッチ操作用パラメータ生成
void GenerateRandomMultitouchParameter(
    float pOutRelativePosX[], float pOutRelativePosY[],
    float pOutTouchDegreeList[], float* radius,
    int* pOutCenterX, int* pOutCenterY,
    float* pOutCenterMoveDeg, float* pOutCenterMoveLength,
    float* pOutStartDegree, float* pOutEndDegree,
    float* pOutStartScale, float* pOutEndScale,
    int* pOutWaitDuration, int* pOutWaitSpan, int* pOutWaitTouchBegin,
    int* pOutWaitTouchEnd, bool* pOutReleaseAfter,
    int touchNum,
    bool isOutOfScreen);


// 接続可能コントローラー数
const int g_ControllerMinId = 0;
const int g_ControllerMaxId = 7;
const int g_ControllerIndexCount        = 8;
const int g_DebugControllerCount        = 1;
const int g_AllControllerIndexRange     = g_ControllerIndexCount;


// タッチスクリーン情報
const int g_MaxTouchNum             = 10;
const int g_ScreenWidth             = 1280;
const int g_ScreenHeight            = 720;


// 乱数を使用したテストの試行回数
const int g_DefaultTryTimes         = 10;


// デフォルト押し込み（waitPress）時間
const int g_DefaultWaitDuration     = 100;
const int g_DefaultWaitPress        = 10;
const int g_DefaultWaitSpan         = 5;

// 乱数用パラメータ
const int   g_RandomInvalidIdRange      = 1000;
const int   g_RandomWaitMaxRange        = 1500;
const float g_RandomScaleMaxRange       = 1000.0f;
const float g_RandomDegreeMaxRange      = 720.0f;
const float g_RandomRadiusMaxRange      = 500.0f;
const float g_RandomBigParameterRate    = 100.0f;

// ボタン値の範囲定義(xpad)
const int g_XpadButtonBeginNum = Button::Button_Home;
const int g_XpadButtonEndNum   = Button::Button_Down;
