﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include "CaptureProcessorWrapper.h"

using namespace captureProcessor;


// キャプチャデバイス名取得テスト
TEST( CaptureProcessorSuite, GetCaptureDeviceInfoTest)
{
     // Capture ライブラリのラッパークラス
    CaptureProcessorWrapper       captureProcessorWrapper;

    // ライブラリ読み込みテスト
    ASSERT_TRUE(captureProcessorWrapper.LoadCaptureLibrary());

    // 関数読み込みテスト
    ASSERT_TRUE(captureProcessorWrapper.LoadFunctiontions());

    //-------------------------------------
    // ビデオ入力デバイス数取得
    //-------------------------------------
    int deviceNum = 0;
    EXPECT_EQ(captureProcessorWrapper.m_GetCaptureDeviceCountFunction(&deviceNum),
        CaptureResult::CaptureResult_Success );

    //-------------------------------------
    // ビデオ入力デバイス名取得
    //-------------------------------------
    const int bufferSize = 256;
    char buffer[bufferSize];

    // 接続されている全てのデバイス名取得
    for (int i = 0; i < deviceNum; i++)
    {
        EXPECT_EQ(captureProcessorWrapper.m_GetCaptureDeviceNameFunction(buffer, bufferSize, i),
            CaptureResult::CaptureResult_Success);
    }

    //-------------------------------------
    // 不正なパラメーターでの実行
    //-------------------------------------
    // 不正なバッファサイズでのデバイス名取得
    for (int i = 0; i < deviceNum; i++)
    {
        EXPECT_EQ(captureProcessorWrapper.m_GetCaptureDeviceNameFunction(buffer, 0, i),
            CaptureResult::CaptureResult_Unexpected);
    }

    // 不正なデバイス ID でのデバイス名取得
    EXPECT_EQ(captureProcessorWrapper.m_GetCaptureDeviceNameFunction(buffer, bufferSize, -1),
        CaptureResult::CaptureResult_Unexpected);
    EXPECT_EQ(captureProcessorWrapper.m_GetCaptureDeviceNameFunction(
        buffer, bufferSize, deviceNum), CaptureResult::CaptureResult_Unexpected);


    // ライブラリ解放テスト
    ASSERT_TRUE(captureProcessorWrapper.ReleaseCaptureLibrary());
}
