﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <Windows.h>
#include <iostream>
#include <cassert>
#include <stdint.h>
#include <autoTestAssistTool/CaptureProcessorTypes.h>
#include <autoTestAssistTool/Common/autoTestAssistTool_LibTypes.h>

namespace captureProcessor
{
    typedef void(*InitializeForCaptureDeviceFunction)(int deviceId, bool isPreview, CaptureResolution resolution);
    typedef CaptureResult(*InitializeForDevkitCapture)(const SerialNumberString& serialNumber, bool isPreview);
    typedef void(*FinalizeFunction)();
    typedef CaptureResult(*GetCaptureDeviceCountFunction)(int* pOutDeviceCount);
    typedef CaptureResult(*GetCaptureDeviceNameFunction)(char* pOutNameBuffer, int nameBufferSize, int deviceId);
    typedef CaptureResult(*GetImageFromCaptureDeviceFunction)(ImageIdType *pOutImageId);
    typedef CaptureResult(*LoadImageFileFunction)(ImageIdType *pOutImageId, const char *filepath);
    typedef CaptureResult(*SaveImageFileFunction)(const char* filepath, ImageIdType id);
    typedef CaptureResult(*ReleaseImageFunction)(ImageIdType id);
    typedef CaptureResult(*ReleaseAllImagesFunction)();
    typedef CaptureResult(*GetImageSizeFunction)(int* pOutWidth, int* pOutHeight, ImageIdType id);
    typedef CaptureResult(*GetImageDataFunction)(void* pOutColorBuffer, size_t colorBufferSize, ImageIdType id);
    typedef MatchingResult(*DetectObjectFunction)(int *pOutX, int *pOutY, ImageIdType id, double threshold);
    typedef MatchingResult(*WaitDetectObjectFunction)(int *pOutX, int *pOutY, ImageIdType id, double threshold, int timeout);

    typedef MatchingResult(*DetectObjectWithFilterFunction)(int* pOutX, int* pOutY, ImageIdType id, double threshold, FilterIdType filterId);
    typedef MatchingResult(*WaitDetectObjectWithFilterFunction)(int* pOutX, int* pOutY, ImageIdType id, double threshold, int timeout, FilterIdType filterId);
    typedef CaptureResult(*GetDotColorFunction)( Rgb24Color pOutColor,  ImageIdType id, int x, int y );
    typedef MatchingResult(*DetectDotColorFunction)( int x, int y, Rgb24Color lowerColor, Rgb24Color upperColoer );
    typedef MatchingResult(*WaitDetectDotColorFunction)( int x, int y,  Rgb24Color lowerColor, Rgb24Color upperColoer, int timeout );
    typedef CaptureResult(*ExecuteLabelingFunction)( int *pOutResultAreaCount, LabelingResultHandleType *pOutLabelingResultHandle, ImageIdType imageId );
    typedef CaptureResult(*ReleaseLabelingResultFunction)(LabelingResultHandleType labelingResultHandle);
    typedef CaptureResult(*GetLabelingResultsFunction)( int *pOutResultsCount, LabelingResult pOutResultArray[], LabelingResultHandleType labelingResultHandle,int arrayCount );
    typedef MatchingResult(*DetectTextForImageFunction)( ImageRect *pOutRect,ImageIdType id,const char regexString[], OcrSeparateLevel separate, OcrLanguage language );
    typedef CaptureResult(*ExecuteOcrFunction)( int *pOutResultCount, OcrResultHandleType *pOutOcrResultHandle, ImageIdType id, OcrSeparateLevel separate, OcrLanguage language );
    typedef CaptureResult(*GetOcrResultStringSizeFunction)( int *pOutResultSize, OcrResultHandleType ocrResultHandle, int number );
    typedef CaptureResult(*GetOcrResultStringFunction)( ImageRect *pOutRect, int *pOutResultSize, char pOutResultString[], int bufferSize, OcrResultHandleType ocrResultHandle, int number );
    typedef CaptureResult(*ReleaseOcrResultFunction)( OcrResultHandleType ocrResultHandle );
    typedef CaptureResult(*CreateFilterFunction)( FilterIdType *pOutFilterId );
    typedef CaptureResult(*DeleteFilterFunction)( FilterIdType filterId );
    typedef CaptureResult(*ApplyFilterFunction)( ImageIdType *pOutId, ImageIdType id, FilterIdType filterId );
    typedef CaptureResult(*SetBinarizationFilterFunction)( FilterIdType filterId, int binarizeThreshold );
    typedef CaptureResult(*SetColorRangeFilterFunction)( FilterIdType filterId, Rgb24Color lowerColor, Rgb24Color upperColor );
    typedef CaptureResult(*SetMorphologyFilterFunction)( FilterIdType filterId, MorphologyConversionType type, int iterations );
    typedef CaptureResult(*OpenImageWindowFunction)( const char* windowName, ImageIdType id );
    typedef CaptureResult(*CloseImageWindowFunction)( const char* windowName );
    typedef CaptureResult(*ExtractImageFunction)( ImageIdType *pOutImageId, ImageIdType id, ImageRect rect );

    class CaptureProcessorWrapper
    {
    public:
        CaptureProcessorWrapper();
        ~CaptureProcessorWrapper();

        bool LoadCaptureLibrary();
        bool ReleaseCaptureLibrary();
        bool LoadFunctiontions();
        bool LoadImageFunctions();
        bool LoadFilterFunctions();
        bool LoadOcrFunctions();
        bool LoadDetectObjectFunctions();

        // APIリスト
        InitializeForCaptureDeviceFunction m_InitializeForCaptureDeviceFunction;
        InitializeForDevkitCapture m_InitializeForDevkitCapture;
        FinalizeFunction m_FinalizeFunction;

        GetCaptureDeviceCountFunction m_GetCaptureDeviceCountFunction;
        GetCaptureDeviceNameFunction m_GetCaptureDeviceNameFunction;
        GetImageFromCaptureDeviceFunction m_GetImageFromCaptureDeviceFunction;
        LoadImageFileFunction m_LoadImageFileFunction;
        SaveImageFileFunction m_SaveImageFileFunction;
        ReleaseImageFunction m_ReleaseImageFunction;
        ReleaseAllImagesFunction m_ReleaseAllImagesFunction;
        GetImageSizeFunction m_GetImageSizeFunction;
        GetImageDataFunction m_GetImageDataFunction;
        DetectObjectFunction m_DetectObjectFunction;
        WaitDetectObjectFunction m_WaitDetectObjectFunction;

        DetectObjectWithFilterFunction m_DetectObjectWithFilterFunction;
        WaitDetectObjectWithFilterFunction m_WaitDetectObjectWithFilterFunction;
        GetDotColorFunction m_GetDotColorFunction;
        DetectDotColorFunction m_DetectDotColorFunction;
        WaitDetectDotColorFunction m_WaitDetectDotColorFunction;
        ExecuteLabelingFunction m_ExecuteLabelingFunction;
        ReleaseLabelingResultFunction m_ReleaseLabelingResultFunction;
        GetLabelingResultsFunction m_GetLabelingResultsFunction;
        DetectTextForImageFunction m_DetectTextForImageFunction;
        ExecuteOcrFunction m_ExecuteOcrFunction;
        GetOcrResultStringSizeFunction m_GetOcrResultStringSizeFunction;
        GetOcrResultStringFunction m_GetOcrResultStringFunction;
        ReleaseOcrResultFunction m_ReleaseOcrResultFunction;
        CreateFilterFunction m_CreateFilterFunction;
        DeleteFilterFunction m_DeleteFilterFunction;
        ApplyFilterFunction m_ApplyFilterFunction;
        SetBinarizationFilterFunction m_SetBinarizationFilterFunction;
        SetColorRangeFilterFunction m_SetColorRangeFilterFunction;
        SetMorphologyFilterFunction m_SetMorphologyFilterFunction;
        OpenImageWindowFunction m_OpenImageWindowFunction;
        CloseImageWindowFunction m_CloseImageWindowFunction;
        ExtractImageFunction m_ExtractImageFunction;

    private:

        HMODULE     m_ModuleHandle;
    };

}
