﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Threading;
using System.Threading.Tasks;

namespace ProdTestTool
{
    class Program
    {
        static void Main(string[] args)
        {
#if true
            Sync.SyncNspInfo();
            Download.MakeDataBase();
#endif

            var romInfos = Download.GetRomInfoList();
            var groupedVersionInfos = Download.GroupRomInfoList(romInfos);
            var appIds = groupedVersionInfos.Keys;

            var options = new ParallelOptions();
            options.MaxDegreeOfParallelism = 8;

            Parallel.ForEach(appIds, options, appId =>
            {
                Console.WriteLine(appId);
                var singleAppId = new string[] { appId };
                Download.DownloadNsp(singleAppId);
                ProdEncrypt.ProdEncryptNsp(singleAppId);
                Common.Cleanup(appId);
            });

#if false
            var systemNspDirs = new string[] {
                Constant.ReleaseBinariesDir + "/NX/Applets",
                Constant.ReleaseBinariesDir + "/NX/Processes/Release",
                Constant.ReleaseBinariesDir + "/NX/SystemData"
            };
            ProdEncrypt.ProdEncryptSystemNsp(systemNspDirs);
#endif
        }
    }
}
