﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.Authoring.AuthoringLibrary;

namespace AuthoringToolsTest
{
    [TestClass]
    public class RangeListTest
    {
        [TestMethod]
        public void DeleteDuplicatedTest()
        {
            {
                RangeList src = new RangeList();
                src.MergingAdd(new Range(0, 1024));

                RangeList sink = new RangeList();
                sink.MergingAdd(new Range(256, 256));
                sink.MergingAdd(new Range(768, 256));

                RangeList deleted = src.GetDuplicatedDeletedList(sink);

                Assert.AreEqual(deleted.Count, 2);
                Assert.AreEqual(deleted[0].Offset, 0);
                Assert.AreEqual(deleted[0].Size, 256);
                Assert.AreEqual(deleted[1].Offset, 512);
                Assert.AreEqual(deleted[1].Size, 256);
            }

            {
                RangeList src = new RangeList();
                src.MergingAdd(new Range(0, 256));
                src.MergingAdd(new Range(512, 256));

                RangeList sink = new RangeList();
                sink.MergingAdd(new Range(0, 1024));

                RangeList deleted = src.GetDuplicatedDeletedList(sink);
                Assert.AreEqual(deleted.Count, 0);
            }

            {
                RangeList src = new RangeList();
                src.MergingAdd(new Range(0, 511));
                src.MergingAdd(new Range(512, 511));

                RangeList sink = new RangeList();
                sink.MergingAdd(new Range(256, 512));

                RangeList deleted = src.GetDuplicatedDeletedList(sink);
                Assert.AreEqual(deleted.Count, 2);
                Assert.AreEqual(deleted[0].Offset, 0);
                Assert.AreEqual(deleted[0].Size, 256);
                Assert.AreEqual(deleted[1].Offset, 768);
                Assert.AreEqual(deleted[1].Size, 255);
            }
        }
    }
}
