﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Xml.Serialization;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.Authoring.AuthoringLibrary;
using TestUtility;

namespace AuthoringToolsTest
{
    [TestClass]
    public class ProgramInfoXmlTest
    {
        [TestMethod]
        public void ProgramInfoModelCreateTest()
        {
            List<ProgramInfoModel> models = new List<ProgramInfoModel>();

            // テストデータ作成
            //   List<ProgramInfoModel> models[3]（内各Entries[2]）
            //   SdkVersion,BuildTypeはmodels[1]のみ設定
            string testDataFormMiddle     = "Middleware{0}";
            string testDataFormDebug      = "DebugApi{0}";
            string testDataFormPrivate    = "PrivateApi{0}";
            string testDataFormUnresolved = "UnresolvedApi{0}";
            string testDataSdkVersion     = "0_11_22";
            string testDataBuildTarget    = "32";
            string testDataBuildType      = "Develop";
            string testDescFilePath       = "C:\\hoge\\test.desc";
            string testDataDesc           = "qxinUvNUxp7GPyfsQFAlL02/q6u5JCFpRCnZh1G1010C8RkhUB6rTiEgK1GWHpwOkxQCGtXdl3TCbgsuPof4BcM1dJSRX9+AbV26a2izlkY6Qk1SqezTwxxXjHURxIvrO6Aprupyq0+g/5cRMxDT/+X9C+bBBNPUo5eITkL3RrzLh03WxKjUJ+/QchCyZLukMeW6bMT0pV/iUWG4+IOCz/nxJntvocIcgnEVNVHd1Q7scHCEERdskE5Bh2fBIisvRdiQw3sniUNSany4+ywniaC1nd6BCqkqOscNgUxNd9DbCJGbwKSfWYAOfrFLR3m220CtueYnLP2K5TUUJuc6yL/JZXaTkKHmDuOCwV3ljB6IxD/4gXyX2bDdfcdM8IFNQZQjIsRd2AkcQ1+SJ3Ye2M49iOO2TUkA+tEj7746Js4cahWTvJypbGoxcfZw+gwcwdaJ02467mCQXeffmElAm/9bOXK9dflj1/vnxIuQEMyZ8+rJIbwL6FULKhQxBpX0OGCcR5n1S9ExpVaj0Yr8jXiNR0AQvszv0/F9Ehh80fawvzhZI9AC0RvDrQRJJPESxkk0D1wMWyKqyv28gATo6rB5gybbEu+Ep6ftl6BrqrLZ6i7lm8MnV6dDj3OUGv2zUdHkAwxJFDH+kWQW49TzCQbp0arm4tQBEhNbKnx+ziFBQ0lEpAIAAAAAAAABAAAAAAABAAAAAAH/////////AUACAAAsAAAAcAIAAA8BAACAAwAAJAAAAAAAAAAAAAAAAQAAAAAAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABWFjYzp1MARhb2M6dQJhcG0HYXBwbGV0T0UGYXVkaW46dQdhdWRvdXQ6dQdhdWRyZW46dQViYW5hbmEFYmNhdDp1BGJzZDp1BWJzZGNmZwZjYXBzOnN1BGNzcm5nB2ZyaWVuZDp1BmZzcC1zcnYCaGlkAmh0YwdodGM6dGVudgNodGNzBWh3b3B1cwJpcnMEbGRuOnUFbGRyOnJvAWxtBG1paTp1A21tOnUHbmZjOm1mOnUHbmZjOnVzZXIHbmZwOnVzZXIFbmlmbTp1BG5zZDp1Am50YwRudmRydgJwY20DcGN0bANwbDp1BnByZXBvOnUCc2V0B3NmZG5zcmVzAnNzbAV0aW1lOnUDdmk6dQC3cwACz///H+//fzCPAQBADwAAcP9fAAD/PzAA/38AAv//AgA="; // BatteryDrainingPerformanceApplication.descのACIDでテスト
            int entryCount = 0;
            for (int i = 0; i < 3; ++i)
            {
                ProgramInfoModel model = new ProgramInfoModel();

                model.MiddlewareListData = MiddlewareList.Create();
                model.DebugApiListData = DebugApiList.Create();
                model.PrivateApiListData = PrivateApiList.Create();
                model.UnresolvedApiListData = UnresolvedApiList.Create();
                model.SdkVersion = null;
                model.BuildTarget = string.Empty;
                model.BuildType = string.Empty;
                model.ToolVersion = null;

                for (int j = 0; j < 2; ++j) {
                    MiddlewareModel middlewareInf = new MiddlewareModel();
                    middlewareInf.ModuleName = string.Format(testDataFormMiddle, entryCount);
                    model.MiddlewareListData.Entries.Add(middlewareInf);

                    DebugApiModel debugInf = new DebugApiModel();
                    debugInf.ApiName = string.Format(testDataFormDebug, entryCount);
                    model.DebugApiListData.Entries.Add(debugInf);

                    PrivateApiModel privateInf = new PrivateApiModel();
                    privateInf.ApiName = string.Format(testDataFormPrivate, entryCount);
                    model.PrivateApiListData.Entries.Add(privateInf);

                    UnresolvedApiModel unresolvedInf = new UnresolvedApiModel();
                    unresolvedInf.ApiName = string.Format(testDataFormUnresolved, entryCount);
                    model.UnresolvedApiListData.Entries.Add(unresolvedInf);

                    ++entryCount;
                }

                models.Add(model);
            }
            models[1].SdkVersion = testDataSdkVersion;
            models[1].BuildTarget = testDataBuildTarget;
            models[1].BuildType = testDataBuildType;
            byte[] acidBinary = Convert.FromBase64String(testDataDesc);

            // マージ
            ProgramInfoModel result = ProgramInfoModel.Create(models, acidBinary, null, testDescFilePath);

            // 答え合わせ
            Assert.AreEqual(result.MiddlewareListData.Entries.Count,    6);
            Assert.AreEqual(result.DebugApiListData.Entries.Count,      6);
            Assert.AreEqual(result.PrivateApiListData.Entries.Count,    6);
            Assert.AreEqual(result.UnresolvedApiListData.Entries.Count, 6);
            for (int i = 0; i < 6; ++i) {
                Assert.AreEqual(result.MiddlewareListData.Entries[i].ModuleName, string.Format(testDataFormMiddle, i));
                Assert.AreEqual(result.DebugApiListData.Entries[i].ApiName, string.Format(testDataFormDebug, i));
                Assert.AreEqual(result.PrivateApiListData.Entries[i].ApiName, string.Format(testDataFormPrivate, i));
                Assert.AreEqual(result.UnresolvedApiListData.Entries[i].ApiName, string.Format(testDataFormUnresolved, i));
            }
            Assert.IsFalse(string.IsNullOrEmpty(result.ToolVersion));
            Assert.AreEqual(result.DescFileName, Path.GetFileName(testDescFilePath));
            Assert.AreEqual(result.Desc, testDataDesc);
            Assert.AreEqual(result.DescFlags.Production, true);
            Assert.AreEqual(result.DescFlags.UnqualifiedApproval, false);
            Assert.AreEqual(result.SdkVersion, testDataSdkVersion);
            Assert.AreEqual(result.BuildTarget, testDataBuildTarget);
            Assert.AreEqual(result.BuildType,  testDataBuildType);
        }
    }
}
