﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using BezelEditor.Foundation.Types;
using Nintendo.Authoring.AuthoringEditor.SelectTwoNspFilesWindow;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.SelectTwoNspFilesWindow
{
    public class SelectTwoFilesWindowVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = new SelectTwoFilesWindowVm(_context.DiContainer, new ComparisonTargetFiles()))
            {
                Assert.NotNull(vm.CloseCommand);
                Assert.NotNull(vm.OkCommand);

                Assert.NotNull(vm.LeftNspFile);
                Assert.NotNull(vm.RightNspFile);

                Assert.Equal(DialogResultType.Cancel, vm.Result);

                Assert.NotNull(vm.LeftType);
                Assert.NotNull(vm.RightType);
            }
        }

        [Fact]
        public void OkCommand()
        {
            using (var vm = new SelectTwoFilesWindowVm(_context.DiContainer, new ComparisonTargetFiles()))
            {
                vm.OkCommand.Execute();
            }
        }

        [Fact]
        public void CloseCommand()
        {
            using (var vm = new SelectTwoFilesWindowVm(_context.DiContainer, new ComparisonTargetFiles()))
            {
                vm.CloseCommand.Execute();
            }
        }
    }
}
