﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Core.Test;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Pages
{
    public class SaveDataPageVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = _context.DiContainer.GetInstance<SaveDataPageVm>())
            {
                Assert.NotEmpty(vm.Params);
            }
        }

        [Theory]
        [InlineData(999, true, 123)]
        [InlineData(123, false, 123)]
        public void SyncSaveDataSizeAndJournalSize(long saveDataJournalSize, bool isSpecifiedSaveDataJournal,
            long saveDataSize)
        {
            using (var project = _context.DiContainer.GetInstance<Project>())
            using (_context.DiContainer.GetInstance<SaveDataPageVm>())
            {
                var a = project.Meta.Application;

                a.SaveDataJournalSize = 999;

                a.IsSpecifiedSaveDataJournal = isSpecifiedSaveDataJournal;
                a.SaveDataSize = saveDataSize;

                Assert.Equal(saveDataJournalSize, a.SaveDataJournalSize);
            }
        }

        [Theory]
        [InlineData(nameof(Application.IsUseUserAccountSaveDataSizeMax), nameof(Application.UserAccountSaveDataSizeMax), nameof(Application.ValidationSaveDataSizeMax))]
        [InlineData(nameof(Application.IsUseUserAccountSaveDataJournalSizeMax), nameof(Application.UserAccountSaveDataJournalSizeMax), nameof(Application.ValidationSaveDataJournalSizeMax))]
        public void SaveDataSizeMax(string isUse, string property, string validation)
        {
            using (var project = _context.DiContainer.GetInstance<Project>())
            using (var vm = _context.DiContainer.GetInstance<SaveDataPageVm>())
            {
                if (project.AppCapability.IsSupportSaveDataSizeExtend == false)
                    return;

                var a = project.Meta.Application;

                Assert.False(vm.HasErrors.Value);

                a.SetPropertyValue(isUse, true);
                Assert.True(vm.HasErrors.Value);
                Assert.Equal(Application.SaveDataSizeMaxValidationType.SizeError,
                    a.GetPropertyValue<Application.SaveDataSizeMaxValidationType>(validation));

                a.SetPropertyValue(property, 1024 * 1024L);
                Assert.False(vm.HasErrors.Value);
                Assert.Equal(Application.SaveDataSizeMaxValidationType.Ok,
                    a.GetPropertyValue<Application.SaveDataSizeMaxValidationType>(validation));

                a.SetPropertyValue(isUse, false);
                a.SetPropertyValue(property, 1024 * 1024L + 1L);
                Assert.False(vm.HasErrors.Value);
                Assert.Equal(Application.SaveDataSizeMaxValidationType.Ok,
                    a.GetPropertyValue<Application.SaveDataSizeMaxValidationType>(validation));

                a.SetPropertyValue(isUse, false);
                a.SetPropertyValue(property, 1L);
                Assert.False(vm.HasErrors.Value);
                Assert.Equal(Application.SaveDataSizeMaxValidationType.Ok,
                    a.GetPropertyValue<Application.SaveDataSizeMaxValidationType>(validation));

            }
        }
    }
}
