﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using BezelEditor.Foundation.Types;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Controls;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Controls
{
    public class SaveDataSizeSimulatorWindowVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = _context.DiContainer.GetInstance<SaveDataSizeSimulatorWindowVm>())
            {
                Assert.NotNull(vm.CloseCommand);
                Assert.NotNull(vm.SetResultAndCloseCommand);
                Assert.NotNull(vm.AddFileCommand);
                Assert.NotNull(vm.ResetCommand);
                Assert.NotNull(vm.MeasureEmulationDirectoryCommand);
                Assert.NotNull(vm.RemoveFileCommand);
                Assert.NotNull(vm.Files);
                Assert.Empty(vm.Files);
                Assert.NotNull(vm.DirectoryCount);
                Assert.Equal(DialogResultType.Cancel, vm.DialogResult);
            }
        }

        [Fact]
        public void CloseCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<SaveDataSizeSimulatorWindowVm>())
            {
                vm.CloseCommand.Execute();
            }
        }

        [Fact]
        public void SetResultAndCloseCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<SaveDataSizeSimulatorWindowVm>())
            {
                vm.SetResultAndCloseCommand.Execute();
            }
        }

        [Fact]
        public void AddFileCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<SaveDataSizeSimulatorWindowVm>())
            {
                Assert.Equal(0, vm.Files.Count);

                vm.AddFileCommand.Execute();

                Assert.Equal(1, vm.Files.Count);
            }
        }

        [Fact]
        public void ResetCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<SaveDataSizeSimulatorWindowVm>())
            {
                Assert.Equal(0, vm.Files.Count);

                vm.AddFileCommand.Execute();

                Assert.Equal(1, vm.Files.Count);

                vm.ResetCommand.Execute();

                Assert.Equal(0, vm.Files.Count);
            }
        }

        [Fact]
        public void MeasureEmulationDirectoryCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<SaveDataSizeSimulatorWindowVm>())
            {
                vm.MeasureEmulationDirectoryCommand.Execute();
            }
        }

        [Fact]
        public void RemoveFileCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<SaveDataSizeSimulatorWindowVm>())
            {
                vm.AddFileCommand.Execute();

                Assert.Equal(1, vm.Files.Count);

                vm.RemoveFileCommand.Execute(vm.Files[0]);

                Assert.Equal(0, vm.Files.Count);
            }
        }
    }
}
