﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow;
using Nintendo.Authoring.AuthoringEditor.MainWindow.AppMenu;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow
{
    public class AppMenuVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = _context.DiContainer.GetInstance<AppMenuVm>())
            {
                Assert.NotNull(vm.CreateNewProjectCommand);
                Assert.NotNull(vm.OpenProjectCommand);
                Assert.NotNull(vm.ImportNspCommand);
                Assert.NotNull(vm.SaveCommand);
                Assert.NotNull(vm.SaveAsCommand);

                Assert.NotNull(vm.SettingAppCommand);
                Assert.NotNull(vm.ShowAboutCommand);
                Assert.NotNull(vm.CloseWindowCommand);

                Assert.NotNull(vm.BackToStartPageCommand);

                Assert.NotNull(vm.MruProjects);
                Assert.NotNull(vm.MruMetas);
                Assert.NotNull(vm.MruNsps);
            }
        }

        [Fact]
        public void CreateNewProjectCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<AppMenuVm>())
            {
                vm.CreateNewProjectCommand.Execute();
            }
        }

        [Fact]
        public void OpenProjectCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<AppMenuVm>())
            {
                vm.OpenProjectCommand.Execute(new MruItemVm(new MruItem()));
            }
        }

        [Fact]
        public void ImportNspCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<AppMenuVm>())
            {
                vm.ImportNspCommand.Execute(new MruItemVm(new MruItem()));
            }
        }

        [Fact]
        public void SaveCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<AppMenuVm>())
            {
                vm.SaveCommand.Execute();
            }
        }

        [Fact]
        public void SaveAsCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<AppMenuVm>())
            {
                vm.SaveAsCommand.Execute();
            }
        }

        [Fact]
        public void SettingAppCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<AppMenuVm>())
            {
                vm.SettingAppCommand.Execute();
            }
        }

        [Fact]
        public void ShowAboutCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<AppMenuVm>())
            {
                vm.ShowAboutCommand.Execute();
            }
        }

        [Fact]
        public void CloseWindowCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<AppMenuVm>())
            {
                vm.CloseWindowCommand.Execute();
            }
        }

        [Fact]
        public void BackToStartPageCommand()
        {
            using (var vm = _context.DiContainer.GetInstance<AppMenuVm>())
            {
                vm.BackToStartPageCommand.Execute();
            }
        }
    }
}
