﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Foundation.Test
{
    public class JpegHelperTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Theory]
        [InlineData(false, "nxicon_testdata/256x256.jpg")]
        [InlineData(true, "nxicon_testdata/progressive.jpg")]
        [InlineData(false, "jpeghelper_testdata/baseline.jpg")]
        public void Basic(bool isProgressive, string jpegFilePath)
        {
            Assert.Equal(isProgressive, JpegHelper.IsProgressive(System.IO.Path.Combine(_context.TestDataDirPath, jpegFilePath)));
        }

        [Fact]
        public void Error_Size()
        {
            var data = new byte[1];

            Assert.False(JpegHelper.IsProgressive(data));
        }

        [Fact]
        public void Error_NotJpeg()
        {
            var data = new byte[3];

            Assert.False(JpegHelper.IsProgressive(data));
        }
    }
}
