﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Core.Test
{
    public class ProjectTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var p = _context.GetInstance<Project>())
            {
                Assert.NotNull(p.Meta);
                Assert.Equal(string.Empty, p.ProgramCodeDirectoryPath);
                Assert.Equal(string.Empty, p.ProgramDataDirectoryPath);
                Assert.Equal(string.Empty, p.ProjectDirectory);
            }
        }

        [Fact]
        public void DiContainer()
        {
            using (var p = _context.GetInstance<Project>())
            {
                Assert.True(ReferenceEquals(p.DiContainer, p.Meta.DiContainer));
            }
        }

        [Fact]
        public void ToAbsolutePath()
        {
            using (var p = _context.GetInstance<Project>())
            {
                Assert.False(string.IsNullOrEmpty(p.ToAbsolutePath("hoge.txt")));
                Assert.Null(p.ToAbsolutePath(null));
                Assert.Null(p.ToAbsolutePath(@"""c:\path\to\location"""));
                {
                    string absolutePath = @"c:\home\path\to\location";
                    Assert.Equal(absolutePath, p.ToAbsolutePath(absolutePath));
                }
            }
        }

        [Fact]
        public void AlwaysRootElementIsNintendoSdkMeta()
        {
            using (var p = _context.GetInstance<Project>())
            {
                Assert.Equal(p.XmlRootMetaKind, RootMetaKind.NintendoSdkMeta);
            }
            using (var p = Project.Import(_context.DiContainer, ImportableFileType.Meta,
                Path.Combine(TestContext.TestDataDirPath, @"metafile_test\Application.nmeta")))
            {
                Assert.Equal(p.XmlRootMetaKind, RootMetaKind.NintendoSdkMeta);
            }
        }
    }
}
