﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Core.Test
{
    public class LanguageHelperTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Theory]
        [InlineData(AreaType.America, LanguageType.AmericanEnglish)]
        [InlineData(AreaType.America, LanguageType.CanadianFrench)]
        [InlineData(AreaType.America, LanguageType.LatinAmericanSpanish)]
        [InlineData(AreaType.Asia, LanguageType.Japanese)]
        [InlineData(AreaType.Asia, LanguageType.SimplifiedChinese)]
        [InlineData(AreaType.Asia, LanguageType.TraditionalChinese)]
        [InlineData(AreaType.Asia, LanguageType.Korean)]
        [InlineData(AreaType.Europe, LanguageType.BritishEnglish)]
        [InlineData(AreaType.Europe, LanguageType.French)]
        [InlineData(AreaType.Europe, LanguageType.German)]
        [InlineData(AreaType.Europe, LanguageType.Spanish)]
        [InlineData(AreaType.Europe, LanguageType.Italian)]
        [InlineData(AreaType.Europe, LanguageType.Dutch)]
        [InlineData(AreaType.Europe, LanguageType.Portuguese)]
        [InlineData(AreaType.Europe, LanguageType.Russian)]
        public void LanguageToArea(AreaType area, LanguageType lang)
        {
            Assert.Equal(area, LanguageHelper.LanguageToArea(lang));
        }

        public static IEnumerable<object> AreaToLanguagesTestData => new[]
        {
            new object[]
            {
                new[]
                {
                    LanguageType.AmericanEnglish,
                    LanguageType.CanadianFrench,
                    LanguageType.LatinAmericanSpanish
                },
                AreaType.America
            },
            new object[]
            {
                new[]
                {
                    LanguageType.Japanese,
                    LanguageType.SimplifiedChinese,
                    LanguageType.TraditionalChinese,
                    LanguageType.Korean,
                },
                AreaType.Asia
            },
            new object[]
            {
                new[]
                {
                    LanguageType.BritishEnglish,
                    LanguageType.French,
                    LanguageType.German,
                    LanguageType.Spanish,
                    LanguageType.Italian,
                    LanguageType.Dutch,
                    LanguageType.Portuguese,
                    LanguageType.Russian
                },
                AreaType.Europe
            },
        };

        [Theory]
        [MemberData(nameof(AreaToLanguagesTestData))]
        public void AreaToLanguages(LanguageType[] languages, AreaType area)
        {
            Assert.Equal(languages, LanguageHelper.AreaToLanguages(area));
        }
    }
}
