﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.ObjectModel;
using System.Linq;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Core.Test
{
    public class AgeRatingTest
    {
        [Fact]
        public void DefaultCtor()
        {
            using (var r = new AgeRating())
            {
                Assert.Equal(
                    new[]
                    {
                        TargetSalesRegion.Japan, TargetSalesRegion.HongKongAndKoreanAndTaiwan,
                        TargetSalesRegion.Americas, TargetSalesRegion.EuropeAndAustralia
                    },
                    r.SelectedTargetSalesRegions.Select(x => x.Region));
            }
        }

        [Theory]
        [InlineData(TargetSalesRegion.Japan, new[] { "CERO" })]
        [InlineData(TargetSalesRegion.HongKongAndKoreanAndTaiwan, new[] { "GRACGCRB", "GSRMR" })]
        [InlineData(TargetSalesRegion.Americas, new[] { "ESRB", "ClassInd" })]
        [InlineData(TargetSalesRegion.EuropeAndAustralia, new[] { "PEGI", "PEGIBBFC", "PEGIPortugal", "USK", "Russian", "ACB", "OFLC" })]
        public void TargetRegions(TargetSalesRegion region, string[] expectedRatings)
        {
            using (var r = new AgeRating())
            {
                var selectedRegion = r.SelectedTargetSalesRegions.FirstOrDefault(x => x.Region == region);
                Assert.NotNull(selectedRegion);
                selectedRegion.IsUse = true;
                Assert.Equal(expectedRatings.OrderBy(x => x), r.ProvidedRatings.Select(x => x.RatingOrganization).OrderBy(x => x));
            }
        }

        [Fact]
        public void CorrectAgeRatingFromRatings()
        {
            using (var ageRating = new AgeRating())
            {
                Assert.Equal(
                    new[]
                    {
                        TargetSalesRegion.Japan,
                        TargetSalesRegion.HongKongAndKoreanAndTaiwan,
                        TargetSalesRegion.Americas,
                        TargetSalesRegion.EuropeAndAustralia
                    },
                    ageRating.SelectedTargetSalesRegions.Select(x => x.Region).ToArray());
            }
        }
    }
}
