﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _3dToolsTestUtility
{
    public class ProcessExecutor
    {
        public static void Execute(string cmd, string args)
        {
            IoUtility.WriteLogLine($"{cmd} {args}");
            StringBuilder logMessage = new StringBuilder();
            StringBuilder errorMessage = new StringBuilder();
            try
            {
                int result = ExecuteProcessImpl(
                    cmd, args, false,
                    x => logMessage.AppendLine(x),
                    x => errorMessage.AppendLine(x));
                if (result != 0)
                {
                    throw new Exception($"エラーコード: 0x{result.ToString("X8")}");
                }
            }
            catch (Exception e)
            {
                throw new Exception($"{cmd} {args} の実行に失敗しました。\n{e.Message}");
            }
            finally
            {
                if (logMessage.Length > 0)
                {
                    IoUtility.WriteLogLine($"標準出力:\n{logMessage.ToString()}");
                }
                if (errorMessage.Length > 0)
                {
                    IoUtility.WriteLogLine($"標準エラー出力:\n{errorMessage.ToString()}");
                }
            }
        }

        private static int ExecuteProcessImpl(
            string cmd, string args, bool useShellExecute,
            Action<string> messageAction,
            Action<string> errorMessageAction)
        {
            var info = new ProcessStartInfo(cmd, args) { UseShellExecute = useShellExecute };
            if (!info.UseShellExecute)
            {
                info.RedirectStandardError = true;
                info.RedirectStandardOutput = true;
                info.CreateNoWindow = true;
            }

            var process = new Process { StartInfo = info };
            if (messageAction != null)
            {
                process.OutputDataReceived += (s, e) =>
                {
                    if (e.Data != null)
                    {
                        messageAction(e.Data);
                    }
                };
            }

            if (errorMessageAction != null)
            {
                process.ErrorDataReceived += (s, e) =>
                {
                    if (e.Data != null)
                    {
                        errorMessageAction(e.Data);
                    }
                };
            }

            process.Start();

            if (!info.UseShellExecute)
            {
                process.BeginOutputReadLine();
                process.BeginErrorReadLine();
            }

            process.WaitForExit();

            return process.ExitCode;
        }
    }
}
