﻿using System;
using System.Text;
using System.Linq;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Reflection;
using nw.g3d.nw4f_3dif;
using nw.g3d.iflib;
using _3dToolsTestUtility;
using Nintendo.G3dTool.Entities;

namespace _3dIntermediateFileOptimizerTest
{
    /// <summary>
    /// サブメッシュ分割のテストです。
    /// </summary>
    [TestClass]
    public class DivideSubmeshTest
    {
        /// <summary>
        /// サブメッシュと LOD モデルを含むモデルに対して LOD 削除とサブメッシュ削除を実行したときのテストです。
        /// </summary>
        [TestMethod]
        public void UniteSubmeshAndTrimLodToSubmeshLodModel()
        {
            G3dParallel.Job = 1;
            string assemblyFolder = System.IO.Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            string sigloRoot = System.IO.Path.Combine(assemblyFolder, "../../../../../../..");
            string resourceFolder = System.IO.Path.Combine(sigloRoot, @"Tests\Tools\Sources\Tests\3dToolsTest\3dIntermediateFileOptimizerTest\Resources");
            var inputFile = System.IO.Path.GetFullPath(System.IO.Path.Combine(resourceFolder, "TrafficSignalSubmeshLod.fmdb"));
            Assert.IsTrue(System.IO.File.Exists(inputFile), $"\"{inputFile}\" was not found.");

            nw.g3d.optcvtr.g3doptcvtr tool = new nw.g3d.optcvtr.g3doptcvtr();
            tool.XsdBasePath = IoUtility.GetXsdBasePath();

            {
                string outputFmdFilePath = IoUtility.GetTempFilePath($"{System.IO.Path.GetFileNameWithoutExtension(inputFile)}.fmdb");
                string args = $"-j 1 --trim-lod-model --unite-submesh {inputFile} -o {outputFmdFilePath}";
                try
                {
                    tool.Arguments = args;
                    tool.Run();

                    // 出力後の fmdb が読み込めるかをテスト
                    nw4f_3difType file = IfReadUtility.Read(outputFmdFilePath, tool.XsdBasePath);
                    modelType model = file.Item as modelType;
                    Assert.IsNotNull(model);

                    // LOD とサブメッシュが消えていることをチェック
                    foreach (shapeType shape in model.shape_array.shape)
                    {
                        Assert.AreEqual(1, shape.mesh_array.mesh.Length);
                        foreach (meshType mesh in shape.mesh_array.mesh)
                        {
                            Assert.AreEqual(1, mesh.submesh_array.submesh.Length);
                        }
                    }
                }
                finally
                {
                    if (System.IO.File.Exists(outputFmdFilePath))
                    {
                        System.IO.File.Delete(outputFmdFilePath);
                    }
                }
            }

            {
                string outputFmdFilePath = IoUtility.GetTempFilePath($"{System.IO.Path.GetFileNameWithoutExtension(inputFile)}.fmdb");
                string args = $"-j 1 --trim-lod-model --unite-submesh {inputFile} -o {outputFmdFilePath} --divide-submesh";
                try
                {
                    // サブメッシュ分割との併用テスト
                    tool.Arguments = args;
                    tool.Run();

                    // 出力後の fmdb が読み込めるかをテスト
                    var file = IfReadUtility.ReadIntermediateFile(outputFmdFilePath, tool.XsdBasePath);
                    var model = file.GetRootEntity<Model>();
                    Assert.IsNotNull(model);

                    var log = model.ProcessLogs.FirstOrDefault(x => x.Process == "divide_submesh");
                    Assert.IsNotNull(log);
                    Assert.IsFalse(string.IsNullOrEmpty(log.Value));

                    // サブメッシュが存在することをチェック
                    bool hasSubmesh = false;
                    foreach (var shape in model.Shapes)
                    {
                        Assert.AreEqual(1, shape.Meshes.Count);
                        foreach (var mesh in shape.Meshes)
                        {
                            hasSubmesh |= mesh.Submeshes.Count > 1;
                        }
                    }

                    Assert.IsTrue(hasSubmesh);
                }
                finally
                {
                    if (System.IO.File.Exists(outputFmdFilePath))
                    {
                        System.IO.File.Delete(outputFmdFilePath);
                    }
                }
            }
        }
    }
}
