﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;
using nw.g3d.nw4f_3dif;

namespace G3dLibraryTest
{
    [TestClass]
    public class ShaderDefinitionTest
    {
        [TestMethod]
        public void ShaderDefinitionReferenceEntityTest()
        {
            var sourceFile = new IntermediateFile(IntermediateFileKind.ShaderDefinition);
            var rootEntity = sourceFile.GetRootEntity<ShaderDefinition>();
            var sourceCodeStream = new StreamWstring();
            rootEntity.Streams.Add(sourceCodeStream);
            rootEntity.ShaderSrcs.Add(new ShaderSrc() { Stream = sourceCodeStream });
            rootEntity.ShaderSrcs.Add(new ShaderSrc() { Stream = sourceCodeStream });
            rootEntity.ShaderSrcs.Add(new ShaderSrc() { Stream = sourceCodeStream });

            {
                int srcIndex = 1;
                var shadingModel = new ShadingModel();
                rootEntity.ShadingModels.Add(shadingModel);
                shadingModel.VertexStage = new VertexStage();
                shadingModel.VertexStage.ShaderSrc = rootEntity.ShaderSrcs[srcIndex];

                var writeData = sourceFile.CreateSerializableData();
                Assert.AreEqual(1, (writeData.Item as shader_definitionType).shading_model_array.Items.Length);
                Assert.AreEqual(srcIndex, (writeData.Item as shader_definitionType).shading_model_array.Items[0].vertex_stage.src_index);

                var file = new IntermediateFile(writeData);
                Assert.AreEqual(file.GetRootEntity<ShaderDefinition>().ShaderSrcs[srcIndex], file.GetRootEntity<ShaderDefinition>().ShadingModels[0].VertexStage.ShaderSrc);
            }
        }
    }
}
