﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nw/g3d/edit/g3d_IAllocator.h>
#include <vector>
#include <stdint.h>

namespace G3dSandbox {

    void* Allocate(size_t size, size_t alignment, void* pUserData);
    void* Allocate(size_t size);
    void Free(void* ptr, void* pUserData);
    void Free(void* ptr, size_t size);

    class SandboxAllocator : public nw::g3d::edit::IAllocator
    {
    public:
        virtual void* Alloc(size_t size, size_t alignment);
        virtual void Free(void* pBuffer);
        void PrintMemoryLeaks();

    private:
        struct AllocationInfo
        {
            uintptr_t address;
            char allocatedFunctionName[512];
        };

        void GetCalledSymbolName( char* pOutSymbolNames, int nameLengthMax, int maxSymbolCount );

        bool RemoveAddress(uintptr_t address);

        AllocationInfo* FindAllocationInfo(uintptr_t address);

        std::vector<AllocationInfo> m_AllocatedAddressList;
    };
}
