﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/g3d_EditDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/edit/g3d_IAllocator.h>

#if _WIN32
#include <nn/os.h>
#else
#include <cafe/os.h>
#endif

namespace nw { namespace g3d { namespace fnd {

class GfxContext;

}}} // namespace nw::g3d::fnd

namespace G3dSandbox
{
    class MutexLockManager
    {
    public:
        MutexLockManager()
        {
#ifdef _WIN32
            nn::os::InitializeMutex( &m_Mutex, false, 0 );
#else
            OSInitMutex(&m_Mutex);
#endif
        }

        ~MutexLockManager()
        {
#ifdef _WIN32
            nn::os::FinalizeMutex( &m_Mutex );
#else
#endif
        }

        void Lock()
        {
#ifdef _WIN32
            nn::os::LockMutex(&m_Mutex);
#else
            OSLockMutex(&m_Mutex);
#endif
        }

        void Unlock()
        {
#ifdef _WIN32
            nn::os::UnlockMutex(&m_Mutex);
#else
            OSUnlockMutex(&m_Mutex);
#endif
        }

    private:
#if _WIN32
        nn::os::MutexType m_Mutex;
#else
        OSMutex m_Mutex;
#endif
    };

    class EditPollThreadManager
    {
    public:
        EditPollThreadManager(
            nw::g3d::edit::EditCallback* pCallback,
            nw::g3d::edit::IAllocator* pAllocator,
            nw::g3d::GfxContext* pCtx);
        virtual ~EditPollThreadManager();

        void CreateThead();

        void StartThead();

        void StopThread()
        {
            m_IsThreadLiving = false;
        }

        void DestroyThread();

        void Lock();

        void Unlock();

    private:
        void ThreadMain();

#ifdef _WIN32
        static void ThreadEntryFunction( void *arg );
#else
        static int ThreadEntryFunction(int intArg, void* ptrArg);
#endif

    private:
        NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditPollThreadManager);

    private:
        static const size_t    s_ThreadStackSize = 8192;

#if _WIN32
        NN_ALIGNAS(4096) char  m_ThreadStack[ s_ThreadStackSize ];
        nn::os::ThreadType     m_Thread;
#else
        char m_ThreadStack[s_ThreadStackSize];
        OSThread m_Thread;
#endif
        MutexLockManager m_MutexLockManager;
        nw::g3d::GfxContext* m_pGfxContext;
        bool m_IsThreadLiving;
    };
}

#endif
