﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include <nnd/tmp451/tmp451.h>

extern "C" void nnMain()
{
    using namespace nnd::tmp451;

    NN_LOG("/// TMP451 Read Temp ///\n");

    NN_LOG("Initialize()\n");
    Initialize();

    uint8_t id = 0;
    NN_LOG("ReadManufacturerId()\n");
    ReadManufacturerId(&id);
    NN_LOG("Manufacture ID: %2x\n",id);

    // ステータスの確認
    Status status;
    NN_LOG("ReadStatus()--------------------------------\n");
    ReadStatus(&status);
    NN_LOG("isBusy                          : %d\n",status.isBusy);
    NN_LOG("isRemoteOpenCircuit             : %d\n",status.isRemoteOpenCircuit);
    NN_LOG("isPin1LocalHighLimitExceeded    : %d\n",status.isPin1LocalHighLimitExceeded);
    NN_LOG("isPin1RemoteHighLimitExceeded   : %d\n",status.isPin1RemoteHighLimitExceeded);
    NN_LOG("isPin2LocalHighLimitExceeded    : %d\n",status.isPin2LocalHighLimitExceeded);
    NN_LOG("isPin2RemoteHighLimitExceeded   : %d\n",status.isPin2RemoteHighLimitExceeded);
    NN_LOG("isPin2LocalLowLimitExceeded     : %d\n",status.isPin2LocalLowLimitExceeded);
    NN_LOG("isPin2RemoteLowLimitExceeded    : %d\n",status.isPin2RemoteLowLimitExceeded);

    // 計測が行われていないことを確認
    while(GetMeasurementMode() != MeasurementMode::Standby)
    {
        NN_LOG("Now being measured....\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
    }
    // Continuous モード
    NN_LOG("StartMeasurement(Continuous)-----------------\n");
    SetMeasurementMode(MeasurementMode::Continuous);

    Temperature local, remote;
    for(int i = 0; i < 10; i++)
    {
        ReadTemperature(&local, Location::Local);
        ReadTemperature(&remote, Location::Remote);
        NN_LOG("Temperature: Local %3d.%4d, Remote  : %3d.%4d\n",local.integer,local.decimal,remote.integer,remote.decimal);
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
    }

    NN_LOG("SetMeasurementMode(Standby)------------------\n");
    SetMeasurementMode(MeasurementMode::Standby);

    // 計測が行われていないことを確認
    while(GetMeasurementMode() != MeasurementMode::Standby)
    {
        NN_LOG("Now being measured....\n");
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
    }
    // OneShot モード
    for(int i = 0; i < 5; i++)
    {
        NN_LOG("StartMeasurement(OneShot)--------------------\n");
        SetMeasurementMode(MeasurementMode::OneShot);

        // 計測が行われていないことを確認
        while(GetMeasurementMode() != MeasurementMode::Standby)
        {
            NN_LOG("Now being measured....\n");
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(500));
        }

        ReadTemperature(&local, Location::Local);
        ReadTemperature(&remote, Location::Remote);
        NN_LOG("Temperature: Local %3d.%4d, Remote  : %3d.%4d\n",local.integer,local.decimal,remote.integer,remote.decimal);

    }

    NN_LOG("Finalize()\n");
    Finalize();


}
