﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_SdkText.h>
#include <nn/nn_Log.h>
#include <nn/os/os_MemoryHeap.h>
#include <nn/os/os_Result.h>
#include <nn/os/os_Event.h>

#include <cstdlib>
#include <cstring>

#include <nn/tics/tics_Api.h>
#include "CrossBar.h"
#include "MuxDemux.h"
#include "MuxDemuxSlot.h"
#include "TCPSlot.h"
#include "testHtc_EchoPlug.h"

/*
    libnn_htc.lib を利用して実装されたエコーサーバ。MUX を使用する。
    1つのクライアントと通信した後、通信が切れるとプログラムも終了する。
*/

extern "C" void nninitStartup()
{
}

extern "C" void nnMain()
{
    // メモリヒープ確保
    NN_LOG("*** nn::os::SetMemoryHeapSize()\n");
    size_t heapSize = 16 * 1024 * 1024; // 16MB
    nn::Result result = nn::os::SetMemoryHeapSize( heapSize );
    NN_ABORT_UNLESS( result.IsSuccess(), NN_TEXT("メモリヒープの確保に失敗しました。") );

    uintptr_t heapAddress;
    result = nn::os::AllocateMemoryBlock( &heapAddress, heapSize );
    NN_ABORT_UNLESS( result.IsSuccess(), NN_TEXT("メモリヒープの確保に失敗しました。") );

    // Siglo 初期化処理
    NN_LOG("*** nn::tics::Initialize()\n");
    nn::tics::Initialize(heapAddress, heapSize);

    NN_LOG("*** ::tics::portability::stl::string()\n");
    const ::tics::portability::stl::string tcpSessionId("tcpserver");
    const ::tics::portability::stl::string tcpSlotId("tcp");
    const ::tics::portability::stl::string tcpPort("6003");

    const ::tics::portability::stl::string muxSessionId("mux");

    const size_t channnelCount = 2;

    const ::tics::portability::stl::string echoSessionIds[channnelCount] =
    {
        ::tics::portability::stl::string("mux:echo1"),
        ::tics::portability::stl::string("mux:echo2")
    };

    // 1 TcpSlot, 1 MuxDemux, N MuxDemux Slot を持つ CrossBar を作成
    NN_LOG("*** ::tics::CrossBar()\n");
    ::tics::CrossBar* pCrossBar = new ::tics::CrossBar();

    NN_LOG("*** ::tics::TCPSlot()\n");
    /* 第3引数 intType を空欄にして、サーバモードに。第4引数 host を空欄にして、任意のアドレスから接続を受け付け。 */
    ::tics::TCPSlot* pTcpSlot = new ::tics::TCPSlot(tcpSlotId, "", "", tcpPort);

    NN_LOG("*** ::tics::CrossBar::AddSlot()\n");
    pCrossBar->AddSlot(tcpSessionId, pTcpSlot);

    NN_LOG("*** ::tics::MuxDemux()\n");
    ::tics::MuxDemux* pMuxDemux = new ::tics::MuxDemux(pCrossBar, muxSessionId);

    NN_LOG("*** ::tics::CrossBar::AddMuxDemux()\n");
    pCrossBar->AddMuxDemux(muxSessionId, pMuxDemux);

    for( int i = 0; i < channnelCount; i++ )
    {
        int channelId = i + 1;
        int channelPriority = 1;

        NN_LOG("*** ::tics::MuxDemuxSlot()\n");
        ::tics::MuxDemuxSlot* pEchoSlot = new ::tics::MuxDemuxSlot(echoSessionIds[i], echoSessionIds[i], channelId, channelPriority);

        NN_LOG("*** ::tics::CrossBar::AddSlot()\n");
        pCrossBar->AddSlot(echoSessionIds[i], pEchoSlot);
    }

    // MuxDemux の Plug を TcpSlot に登録
    NN_LOG("*** ::tics::MuxDemux::RegisterForSessionStart()\n");
    pCrossBar->RegisterForSessionStart(tcpSessionId, pMuxDemux->GetPlug());

    // EchoPlug を登録
    for( int i = 0; i < channnelCount; i++ )
    {
    NN_LOG("*** EchoPlug()\n");
        ::EchoPlug* pEchoPlug = new ::EchoPlug();

        NN_LOG("*** ::tics::CrossBar::RegisterForSessionStart()\n");
        pCrossBar->RegisterForSessionStart(echoSessionIds[i], pEchoPlug);
    }

    // 処理開始
    NN_LOG("*** ::tics::CrossBar::Run()\n");
    pCrossBar->Run();
    delete pCrossBar;

    NN_LOG("*** nn::tics::Finalize()\n");
    nn::tics::Finalize();

    NN_LOG("*** Finish!\n");
}
