﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Net.Sockets;

namespace AbuseHostShell
{
    class AbuseConnection
    {

        private UInt16 port = 8020;
        private String addr = "127.0.0.1";
        private TcpClient client = null;
        private bool connected = false;
        private bool running = false;
        private Mutex quitMutex = new Mutex();

        public String Address
        {
            get { return addr; }
            set { addr = value; }
        }

        public UInt16 Port
        {
            get { return port; }
            set { port = value; }
        }

        public bool Connect(String host, UInt16 _port)
        {
            addr = host;
            port = _port;
            // TCP ソケットを作成、EndPoint 情報を基に Connect
            client = new TcpClient();
            client.Connect(addr, port);
            Console.WriteLine("Connected to server on target.");
            connected = true;
            return true;
        }

        public bool Disconnect()
        {
            client.Close();
            connected = false;
            return true;
        }

        public bool IsConnected()
        {
            return connected;
        }

        public void RunShell()
        {
            running = true;
            while (running)
            {
                SendCommand();
                Receive();
            }

            Disconnect();
        }

        private async void SendCommand()
        {
            NetworkStream stream = client.GetStream();
            while (running)
            {
                String command = Console.ReadLine();
                if (command == "Quit")
                    running = false;
                else
                {
                    byte[] byteCommand = Encoding.ASCII.GetBytes(command);
                    await stream.WriteAsync(byteCommand, 0, byteCommand.Length);
                }
            }
        }

        private async void Receive()
        {
            NetworkStream stream = client.GetStream();
            byte[] readBuffer = new byte[1024];
            while (running)
            {
                for (int i = 0; i < readBuffer.Length; ++i)
                    readBuffer[i] = 0;

                await stream.ReadAsync(readBuffer, 0, 1024);

                if(readBuffer != null)
                    Console.WriteLine(Encoding.ASCII.GetString(readBuffer));
            }
        }
    }
}
