﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include "abuse_ui_RootContext.h"

namespace nnt {
namespace abuse {


// root of the UI display
RootContext::RootContext(const unsigned width, const unsigned height) NN_NOEXCEPT
    : glv::Window(width, height, "abuse_ui")
    , glv::GLV()
    , m_RootView(width, height)
{
    m_RootStyle.color.back.set(0);
    style(&m_RootStyle);

    m_RootView.pos(glv::Place::TL, 0, 0);

    *this << m_RootView;

    this->setGLV(*this);
}

RootContext::~RootContext() NN_NOEXCEPT
{
}

void RootContext::OnLoopAttached(glv::ApplicationLoopContext& context) NN_NOEXCEPT
{
    ApplicationLoopCallback::OnLoopAttached(context);
}

void RootContext::OnLoopDetached(glv::ApplicationLoopContext& context) NN_NOEXCEPT
{
    ApplicationLoopCallback::OnLoopDetached(context);
}

const glv::RequiredRestoration RootContext::OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT
{
    return glv::RequiredRestoration::RequireRestrationNothing;
}

const glv::RequiredRestoration RootContext::OnLoopAfterSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT
{
    return glv::RequiredRestoration::RequireRestrationNothing;
}

} // ~abuse
} // ~nnt
