﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include "abuse_ui_PageView.h"

namespace nnt {
namespace abuse {

class HomeView : public PageView
{
    NN_DISALLOW_COPY( HomeView );
    NN_DISALLOW_MOVE( HomeView );

public:
    explicit HomeView(ContentView& content) NN_NOEXCEPT;

    ~HomeView() NN_NOEXCEPT;

    virtual const char *className() const { return "HomeView"; };

    virtual void onAnimate(double dsec) NN_NOEXCEPT;

private:
    glv::Label         m_Message;

    bool               m_ShowDetail;

private:
    void ShowDetail() NN_NOEXCEPT;
    void HideDetail() NN_NOEXCEPT;

    static void OnDataRoleChange(const glv::Notification& n) NN_NOEXCEPT;
    static void OnDeviceUpdate(const glv::Notification& n) NN_NOEXCEPT;
    static void OnShowDetail(const glv::Notification& n) NN_NOEXCEPT;
    static void OnHideDetail(const glv::Notification& n) NN_NOEXCEPT;
};

} // ~abuse
} // ~nnt
