﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <Tasks/BaseTask.h>

namespace nnt {
    namespace abuse {

        class LogReaderTask : public BaseTask
        {
        public:
            LogReaderTask(const String& typeName, const String& instanceName);
            virtual ~LogReaderTask();
            virtual InitStatus Initialize(const String& params);
            virtual StartStatus Start();
            virtual RunStatus Run();
            virtual StopStatus Stop();
            virtual ShutdownStatus Shutdown();

            virtual const char* GetParamOptions();

        private:
            StringVector m_readFilenames;
            StringVector m_writeFilenames;
            std::vector<File, PlatformAllocator<File>> m_readFiles;
            std::vector<File, PlatformAllocator<File>> m_writeFiles;
            String m_readDir;
            String m_writeDir;
            nn::os::MutexType s_LogMutex;
            bool m_doneReadingLogs;
            bool m_doneProcessingFiles;
            const int LOG_READER_BUFFER_SIZE = 1024; // const because our CI system does not like defines.
            char m_buffer[1024 + 1];
        };

    }
}
