﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "BaseTask.h"

namespace nnt
{
    namespace abuse
    {
        enum ImplType
        {
            MTX,
            C,
            ASMP,
            COMPARE,
        };

        class CpuMatrixTask;
        typedef bool (CpuMatrixTask::*MatrixFunction) (ImplType type);

        class CpuMatrixTask : public BaseTask
        {

        public:
            CpuMatrixTask(const String& typeName, const String& instanceName);
            virtual ~CpuMatrixTask();

            virtual InitStatus Initialize(const String& params);
            virtual StartStatus Start();
            virtual RunStatus Run();
            virtual StopStatus Stop();
            virtual ShutdownStatus Shutdown();

            bool TestVecAdd(ImplType type);
            bool TestMTX4x4MultVec(ImplType type);
        private:
            int m_functionIndex;
            int m_testIterations;
            int runs;
        };
    }
}
