﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <Commands/BaseCommand.h>
namespace nnt
{
    namespace abuse
    {
        struct CommandStartLoop : public BaseCommand
        {
            CommandStartLoop();
            ~CommandStartLoop();
            bool Execute(unsigned& nextCommand) override;
            ParseResult ParseArgs(const ArgVector& args, CommandVector& commandList) override;

            unsigned loopFinishedIndex;
            unsigned curItr;
            unsigned* maxItr;
            String itrName;
            bool deleteMaxItr;

        private:
            bool parseIterator(const ScriptArg& arg, const CommandVector& commands);
            bool parseName(const ScriptArg& arg, const CommandVector& commands);
        };

        struct CommandEndLoop : public BaseCommand
        {
            CommandEndLoop() : BaseCommand(), startLoopIndex(0) {};
            ~CommandEndLoop() {};
            bool Execute(unsigned& nextCommand) override;
            ParseResult ParseArgs(const ArgVector& args, CommandVector& commandList) override;

            unsigned startLoopIndex;
        };
    }
}
