﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <vector>
#include <Platform.h>
#include <AbuseString.h>
namespace nnt
{
    namespace abuse
    {
        class BaseCommand;
        typedef BaseCommand* (*CreateCommandFunc)();

        enum CommandType
        {
            COMMAND_WAIT = 0,
            COMMAND_START_LOOP,
            COMMAND_END_LOOP,
            COMMAND_CREATE_TASK,
            COMMAND_KILL_TASK,
            COMMAND_KILL_ALL_TASKS,
            COMMAND_SUSPEND_TASK,
            COMMAND_SUSPEND_ALL_TASKS,
            COMMAND_RESUME_TASK,
            COMMAND_RESUME_ALL_TASKS,
            COMMAND_UNKNOWN,
        };

        enum ParseResult
        {
            PARSE_SUCCESS = 0,
            PARSE_INVALID_ARG = 1,
            PARSE_UNMATCHED_COMMAND = 2,
        };

        struct RegisteredCommand
        {
            RegisteredCommand(const char* commandName, CommandType commandType, CreateCommandFunc createFunc) : name(commandName), command(commandType), create(createFunc) {}
            const char* name;
            CommandType command;
            CreateCommandFunc create;
        };

        struct ScriptArg
        {
            String argName;
            String argValue;
        };

        typedef std::vector<ScriptArg, PlatformAllocator<ScriptArg>> ArgVector;
        typedef std::vector<BaseCommand*, PlatformAllocator<BaseCommand*>> CommandVector;
        typedef std::vector<unsigned*, PlatformAllocator<unsigned*>> IteratorVector;

        const unsigned GetNumRegisteredCommands();
        bool ParseInt(int* parsedInt, const String& buffer);
        bool ParseUnsigned(unsigned* parsedInt, const String& buffer);
        bool ParseIteratorValues(const String& name, const CommandVector& commands, IteratorVector& iterators, String& formattedName);
        unsigned* ParseIteratorValue(const String& name, const CommandVector& commands);
        void BuildFormattedName(String& formattedName, const IteratorVector& iterators, String& result);

        template <typename Command>
        static BaseCommand* CreateCommand()
        {
            Command* command = (Command*)Platform::Allocate(sizeof(Command));
            new (command) Command();
            return command;
        }
    }
}
