﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <vector>
#include <Platform.h>
#include <Commands/CommandCommon.h>

namespace nnt
{
    namespace abuse
    {
        class BaseCommand
        {
            friend class FileUtility;
        public:
            BaseCommand() : m_fileLine(-1), m_commandIndex(0xFFFFFFFF){};
            virtual ~BaseCommand() {};
            virtual bool Execute(unsigned& commandIndex) = 0;
            virtual ParseResult ParseArgs(const ArgVector& args, CommandVector& commandList) = 0;

            int GetFileLine();
            const char* GetCommandName();
            CommandType GetCommandType();

        private:
            int m_fileLine;
            unsigned m_commandIndex;
        };
    }
}
