﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "util_ProcessImageMemory.h"
#include "util_KipUtil.h"
#include "util_KipFormat.h"
#include "test_TestSvc.h"

class TestLoader
{
    public:
        TestLoader(const char* file, size_t size);
        TestLoader(const char* file, size_t size, uint64_t codeAddr);

        ~TestLoader()
        {
        }

        void SpawnProcess(nn::svc::Handle* pOutProcess);
        void StartProcess(nn::svc::Handle process);

        void SetCapability(const nn::Bit32* capability, int32_t num)
        {
            mCapability = capability;
            mNumCapability = num;
        }

        void SetProcessCodeArea(uintptr_t addr, int32_t numPages)
        {
            mProcessHeader.memoryAddress = addr;
            mProcessHeader.memoryNumPages = numPages;
        }

        void SetProcessFlag(nn::Bit32 flags)
        {
            mProcessHeader.flags = flags;
        }

        void SetPriority(int32_t priority) { mPriority = priority; }
        void SetProcessorId(int32_t id) { mProcessorId = id; }
        void SetStackSize(int32_t stackSize) { mStackSize = stackSize; }
        void SetAdditionalCapability(nn::Bit32* capability, int32_t num);

        bool Is64Bit() const { return mIs64Bit; }

    private:
        uint64_t mCodeAddress;
        const char* mFilePtr;
        size_t mFileSize;
        nn::svc::CreateProcessParameter mProcessHeader;
        KipFormat mKip;
        const nn::Bit32* mCapability;
        int32_t mNumCapability;
        int32_t mPriority;
        int32_t mProcessorId;
        int32_t mStackSize;
        nn::Bit32* mAdditionalCapability;
        int32_t mNumAdditionalCapability;
        bool mIs64Bit;
};

