﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "util_TestIpc.h"

class TestMemoryStateProcess
{
public:
    TestMemoryStateProcess();
    ~TestMemoryStateProcess();

    // 指定したメモリ状態の領域を取得
    void GetMemoryArea(uint64_t* pAddr, uint64_t* pSize, nn::svc::MemoryState state);

    // 前回取得したメモリ領域を解放する
    void FreeMemoryArea();

    // MemoryState_Normal の領域を確保する
    void GetNormalArea(uint64_t* pAddr, uint64_t size);

    // 指定した領域を MemoryAttribute_Uncached にする
    void SetUncached(uint64_t addr, uint64_t size);

    // 指定した領域から MemoryAttribute_Uncached を外す
    void UnsetUncached(uint64_t addr, uint64_t size);

    nn::svc::Handle GetHandle() const { return m_ProcessHandle; }

    bool Is64Bit() const { return m_Is64Bit; }

    // 終了処理
    void Close();

    void SetDead() { m_IsEnd = true; }

private:
    NamedPortManager m_PortManager;
    nn::svc::Handle m_ProcessHandle;
    nn::svc::Handle m_ServerSession;
    bool m_IsEnd;
    bool m_Is64Bit;
};

