﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Server.h>
#include <nn/svc/svc_Tcb.h>
#include <cstring>
#include <nn/nn_Log.h>
#include "util_KipUtil.h"
#include "util_ProcessImageMemory.h"

namespace {
} // namespace

void ReadKipHeader(KipFormat* pOut, const char* pFile, size_t fileSize)
{
    NN_ASSERT(fileSize > sizeof(KipFormat));
    ::std::memcpy(pOut, pFile, sizeof(KipFormat));
    NN_ASSERT(pOut->IsValid());
}

size_t GetMemorySize(const KipFormat& kip)
{
    if (kip.GetBssMemorySize())
    {
        return kip.GetBssAddress() + kip.GetBssMemorySize() - kip.GetExAddress() + ArgumentSize;
    }
    if (kip.GetRwMemorySize())
    {
        return kip.GetRwAddress() + kip.GetRwMemorySize() - kip.GetExAddress() + ArgumentSize;
    }
    if (kip.GetRoMemorySize())
    {
        return kip.GetRoAddress() + kip.GetRoMemorySize() - kip.GetExAddress() + ArgumentSize;
    }
    return kip.GetExMemorySize() + ArgumentSize;
}

void MakeProcessParameter(
        nn::svc::CreateProcessParameter* pHeader, const KipFormat& kip,
        uint64_t base, size_t size)
{
    std::memset(pHeader, 0, sizeof(nn::svc::CreateProcessParameter));
    pHeader->memoryAddress   = base;
    pHeader->memoryNumPages  = SizeToPage(size);
    pHeader->programId       = kip.GetProgramId();
    pHeader->version         = kip.GetVersion();
    pHeader->flags           = 0;

    if (kip.Is64Bit())
    {
        pHeader->flags |= nn::svc::CreateProcessParameterFlag_64Bit;
    }
    if (kip.Is64BitSpace())
    {
        pHeader->flags |= nn::svc::CreateProcessParameterFlag_AddressSpace64Bit;
    }

    pHeader->flags |= nn::svc::CreateProcessParameterFlag_EnableJitDebug;

    kip.GetName(pHeader->name, sizeof(pHeader->name));
}

