﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include <cstring>
#include <nn/svc/svc_Types.h>
#include <nn/nn_Macro.h>

class KipFormat
{
#define PADDING(pos,dst)    uint8_t padding ## pos [(dst)-(pos)] NN_IS_UNUSED_MEMBER
    uint8_t  m_Signature[4];
    uint8_t  m_Name[12];
    uint64_t m_ProgramId;
    nn::Bit32    m_RemasteringVersion;
    uint8_t  m_Flags[4];
    uint32_t m_ExAddress;
    uint32_t m_ExMemorySize;
    uint32_t m_ExBinarySize;
    uint32_t m_AffinityMask;
    uint32_t m_RoAddress;
    uint32_t m_RoMemorySize;
    uint32_t m_RoBinarySize;
    uint32_t m_StackSize;
    uint32_t m_RwAddress;
    uint32_t m_RwMemorySize;
    uint32_t m_RwBinarySize;
    PADDING(0x4c, 0x50);
    uint32_t m_BssAddress;
    uint32_t m_BssMemorySize;
    PADDING(0x58, 0x80);
    nn::Bit32    m_KernelCapabilities[0x80 / sizeof(uint32_t)];
#undef PADDING
public:
    bool IsValid() const
    {
        return (m_Signature[0] == 'K' &&
                m_Signature[1] == 'I' &&
                m_Signature[2] == 'P' &&
                m_Signature[3] == '1');
    }
    void GetName(char* pBuffer, size_t size) const
    {
        std::memset(pBuffer, 0, size);
        std::memcpy(pBuffer, m_Name, ((size > sizeof(m_Name))? sizeof(m_Name): size));
    }
    uint64_t GetProgramId() const
    {
        return m_ProgramId;
    }
    nn::Bit32 GetVersion() const
    {
        return m_RemasteringVersion;
    }
    uint32_t GetExAddress() const
    {
        return m_ExAddress;
    }
    uint32_t GetExMemorySize() const
    {
        return m_ExMemorySize;
    }
    uint32_t GetExBinarySize() const
    {
        return m_ExBinarySize;
    }
    uint32_t GetRoAddress() const
    {
        return m_RoAddress;
    }
    uint32_t GetRoMemorySize() const
    {
        return m_RoMemorySize;
    }
    uint32_t GetRoBinarySize() const
    {
        return m_RoBinarySize;
    }
    uint32_t GetRwAddress() const
    {
        return m_RwAddress;
    }
    uint32_t GetRwMemorySize() const
    {
        return m_RwMemorySize;
    }
    uint32_t GetRwBinarySize() const
    {
        return m_RwBinarySize;
    }
    uint32_t GetBssAddress() const
    {
        return m_BssAddress;
    }
    uint32_t GetBssMemorySize() const
    {
        return m_BssMemorySize;
    }
    uint32_t GetAffinityMask() const
    {
        return m_AffinityMask;
    }
    uint32_t GetStackSize() const
    {
        return m_StackSize;
    }
    const nn::Bit32* GetKernelCapabilities() const
    {
        return m_KernelCapabilities;
    }
    size_t GetKernelCapabilitiesSize() const
    {
        return sizeof(m_KernelCapabilities);
    }
    uint8_t GetPriority() const
    {
        return m_Flags[0];
    }
    uint8_t GetIdealProcessor() const
    {
        return m_Flags[1];
    }
    bool IsExCompressed() const
    {
        return m_Flags[3] & (1 << 0);
    }
    bool IsRoCompressed() const
    {
        return m_Flags[3] & (1 << 1);
    }
    bool IsRwCompressed() const
    {
        return m_Flags[3] & (1 << 2);
    }
    bool Is64Bit() const
    {
        return m_Flags[3] & (1 << 3);
    }
    bool Is64BitSpace() const
    {
        return m_Flags[3] & (1 << 4);
    }
};
static_assert(sizeof(KipFormat) == 0x100, "");

struct ProgramInfo
{
    KipFormat m_KipHeader;
};

