﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/svc/svc_Types.common.h>

bool CheckProcessState(nn::svc::Handle processHandle, nn::svc::ProcessState state);
nn::Result ContinueDebugProcess(nn::svc::Handle debugHandle);
nn::Result WaitAndGetDebugEvent(nn::svc::DebugEventInfo* pOut, nn::svc::Handle debugHandle, int64_t ns = -1);
void WaitDebugEvent(nn::svc::DebugEventInfo* pOut, nn::svc::Handle debugHandle);
void InitDebugProcess(nn::svc::Handle* pHandle, nn::Bit64* pTid, TestProcess* process);
void ExitDebugProcess(nn::svc::Handle debugProcess, int threadNum);

