﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/TargetConfigs/build_Fpu.h>
#include <nn/svc/svc_BaseId.autogen.h>

#if defined NN_BUILD_CONFIG_CPU_ARM64
    .section .text, "ax"
    .align   2
    .global  TestThreadEntry0
    .type    TestThreadEntry0, %function
TestThreadEntry0:
    bl      1f
1:  mov     x1, sp
    sub     x2, x30, #4
    bl      TestThreadFunction0
    mov     x0, #0
    ldr     x1, [x0]
    .size   TestThreadEntry0, [. - TestThreadEntry0]

    .section .text, "ax"
    .align   2
    .global  GetFpuContext
    .type    GetFpuContext, %function
GetFpuContext:
    mrs     x3, fpcr
    str     w3, [x1]
    mrs     x3, fpsr
    str     w3, [x2]

    stp     q0, q1, [x0, #(0 * 16)]
    stp     q2, q3, [x0, #(2 * 16)]
    stp     q4, q5, [x0, #(4 * 16)]
    stp     q6, q7, [x0, #(6 * 16)]
    stp     q8, q9, [x0, #(8 * 16)]
    stp     q10, q11, [x0, #(10 * 16)]
    stp     q12, q13, [x0, #(12 * 16)]
    stp     q14, q15, [x0, #(14 * 16)]
    stp     q16, q17, [x0, #(16 * 16)]
    stp     q18, q19, [x0, #(18 * 16)]
    stp     q20, q21, [x0, #(20 * 16)]
    stp     q22, q23, [x0, #(22 * 16)]
    stp     q24, q25, [x0, #(24 * 16)]
    stp     q26, q27, [x0, #(26 * 16)]
    stp     q28, q29, [x0, #(28 * 16)]
    stp     q30, q31, [x0, #(30 * 16)]
    ret
    .size   GetFpuContext, [. - GetFpuContext]

    .section .text, "ax"
    .align   2
    .global  SetFpuContext
    .type    SetFpuContext, %function
SetFpuContext:
    ldr     w3, [x1]
    msr     fpcr, x3
    ldr     w3, [x2]
    msr     fpsr, x3
    ldp     q0, q1, [x0, #(0 * 16)]
    ldp     q2, q3, [x0, #(2 * 16)]
    ldp     q4, q5, [x0, #(4 * 16)]
    ldp     q6, q7, [x0, #(6 * 16)]
    ldp     q8, q9, [x0, #(8 * 16)]
    ldp     q10, q11, [x0, #(10 * 16)]
    ldp     q12, q13, [x0, #(12 * 16)]
    ldp     q14, q15, [x0, #(14 * 16)]
    ldp     q16, q17, [x0, #(16 * 16)]
    ldp     q18, q19, [x0, #(18 * 16)]
    ldp     q20, q21, [x0, #(20 * 16)]
    ldp     q22, q23, [x0, #(22 * 16)]
    ldp     q24, q25, [x0, #(24 * 16)]
    ldp     q26, q27, [x0, #(26 * 16)]
    ldp     q28, q29, [x0, #(28 * 16)]
    ldp     q30, q31, [x0, #(30 * 16)]
    ret
    .size   SetFpuContext, [. - SetFpuContext]

    .section .text, "ax"
    .align   2
    .global  TestSetJmp
    .type    TestSetJmp, %function
TestSetJmp:
    stp     x19, x20, [x0, #0 * 8]
    stp     x21, x22, [x0, #2 * 8]
    stp     x23, x24, [x0, #4 * 8]
    stp     x25, x26, [x0, #6 * 8]
    stp     x27, x28, [x0, #8 * 8]
    stp     x29, x30, [x0, #10 * 8]
    mov     x1,  sp
    stp     x1,  x2,  [x0, #12 * 8]
    stp     q8,  q9,  [x0, #14 * 8]
    stp     q10, q11, [x0, #18 * 8]
    stp     q12, q13, [x0, #22 * 8]
    stp     q14, q15, [x0, #26 * 8]
    mov     x0, #0
    ret
    .size   TestSetJmp, [. - TestSetJmp]

    .section .text, "ax"
    .align   2
    .global  TestLongJmp
    .type    TestLongJmp, %function
TestLongJmp:
    ldp     x19, x20, [x0, #0 * 8]
    ldp     x21, x22, [x0, #2 * 8]
    ldp     x23, x24, [x0, #4 * 8]
    ldp     x25, x26, [x0, #6 * 8]
    ldp     x27, x28, [x0, #8 * 8]
    ldp     x29, x30, [x0, #10 * 8]
    ldp     x1,  x2,  [x0, #12 * 8]
    mov     sp, x1
    ldp     q8,  q9,  [x0, #14 * 8]
    ldp     q10, q11, [x0, #18 * 8]
    ldp     q12, q13, [x0, #22 * 8]
    ldp     q14, q15, [x0, #26 * 8]
    mov     x0, #1
    ret
    .size   TestLongJmp, [. - TestLongJmp]

#else
    .section .text, "ax"
    .align   2
    .global  TestThreadEntry0
    .type    TestThreadEntry0, %function
TestThreadEntry0:
    bl      1f
1:  mov     r1, sp
    sub     r2, lr, #4
    bl      TestThreadFunction0
    mov     r0, #0
    ldr     r1, [r0]
    .size   TestThreadEntry0, [. - TestThreadEntry0]


    .section .text, "ax"
    .align   2
    .global  GetFpuContext
    .type    GetFpuContext, %function
GetFpuContext:
    fmrx    r2, fpscr
    str     r2, [r1]

    fstmiad r0!, { d0-d15 }
#if NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS == 32
    fstmiad r0!, { d16-d31 }
#endif
    bx lr
    .size   GetFpuContext, [. - GetFpuContext]

    .section .text, "ax"
    .align   2
    .global  SetFpuContext
    .type    SetFpuContext, %function
SetFpuContext:
    fldmiad r0!, { d0-d15 }
#if NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS == 32
    fldmiad r0!, { d16-d31 }
#endif
    ldr     r2, [r1]
    fmxr    fpscr, r2
    bx lr
    .size   SetFpuContext, [. - SetFpuContext]


    .section .text, "ax"
    .align   2
    .global  TestSetJmp
    .type    TestSetJmp, %function
TestSetJmp:
    stmia   r0!, {r4, r5, r6, r7, r8, r9, r10, r11}
    mov     r1, sp
    stmia   r0!, {r1, lr}
    fstmiad r0!, { d8-d15 }
    mov r0, #0
    bx lr
    .size   TestSetJmp, [. - TestSetJmp]

    .section .text, "ax"
    .align   2
    .global  TestLongJmp
    .type    TestLongJmp, %function
TestLongJmp:
    ldmia   r0!, {r4, r5, r6, r7, r8, r9, r10, r11}
    ldmia   r0!, {r1, lr}
    mov     sp, r1
    fldmiad r0!, { d8-d15 }
    mov r0, #1
    bx lr
    .size   TestLongJmp, [. - TestLongJmp]
#endif

