﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>
#include <cstring>
#include <nn/svc/svc_BaseId.autogen.h>

namespace {
}
extern "C" void nnMain();





TEST(StartProcess, NormalTest)
{
    TestProcessLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;
    nn::svc::CreateProcessParameter param = {};
    nn::Bit32 flags[DefaultCapabilityFlagNum];
    SetDefaultCapability(flags, DefaultCapabilityFlagNum);

    // TEST 122-7
    // 最高優先度から最低優先度までを受け付ける
    for (int pri = 0; pri < 64; pri++)
    {
        // TEST 122-10
        // 存在するコア番号を指定することが出来る
        for (int coreNo = 0; coreNo < NumCore; coreNo++)
        {
            bool is64Bit = false;
            std::strncpy(param.name, "test", sizeof(param.name));
            param.version        = 0xbabeface;
            param.programId      = 0xdeadbeef0badcafeull;
            param.memoryAddress  = 0x00200000;
            param.memoryNumPages = 1;
            param.flags          = 0x00000000;

            result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
            ASSERT_RESULT_SUCCESS(result);

            {
                result = nn::svc::MapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000);
                ASSERT_RESULT_SUCCESS(result);

                *reinterpret_cast<uint32_t*>(g_FreeAreaBegin) = (is64Bit?(0xd4000001 | (NN_SVC_ID_EXIT_PROCESS << 5)):(0xef000000 | NN_SVC_ID_EXIT_PROCESS));

                result = nn::svc::UnmapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000);
                ASSERT_RESULT_SUCCESS(result);

                result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000, nn::svc::MemoryPermission_ReadExecute);
                ASSERT_RESULT_SUCCESS(result);
            }

            // TEST 122-1
            // INITIALIZING 状態のプロセスのハンドルを受け付ける
            // TEST 122-12
            // 4KB にアライメントされている値を受け付ける
            result = nn::svc::StartProcess(handle, pri, coreNo, 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            WaitProcess(handle);

            result = nn::svc::CloseHandle(handle);
            ASSERT_RESULT_SUCCESS(result);
        }
    }

    {
        int pri = 16;

        bool is64Bit = false;
        std::strncpy(param.name, "test", sizeof(param.name));
        param.version        = 0xbabeface;
        param.programId      = 0xdeadbeef0badcafeull;
        param.memoryAddress  = 0x00200000;
        param.memoryNumPages = 1;
        param.flags          = 0x00000000;

        result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
        ASSERT_RESULT_SUCCESS(result);

        {
            result = nn::svc::MapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            *reinterpret_cast<uint32_t*>(g_FreeAreaBegin) = (is64Bit?(0xd4000001 | (NN_SVC_ID_EXIT_PROCESS << 5)):(0xef000000 | NN_SVC_ID_EXIT_PROCESS));

            result = nn::svc::UnmapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000, nn::svc::MemoryPermission_ReadExecute);
            ASSERT_RESULT_SUCCESS(result);
        }

        // TEST 122-18
        // 許可されていないコアを指定することは出来ない
        nn::Bit64 coreMask;
        result = nn::svc::GetInfo(&coreMask, nn::svc::InfoType_CoreMask, handle, 0);
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(coreMask != 0);
        ASSERT_TRUE(coreMask == ((1ull << NumCore) - 1));

        int coreNo = 64 - __builtin_clzll(coreMask);
        result = nn::svc::StartProcess(handle, pri, coreNo, 0x1000);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCoreNumber());

        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }
}

