﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Dd.h>

namespace {

volatile char g_Buffer[0x1000] __attribute__((aligned(0x1000)));

} // namespace

TEST(SetMemoryAttribute, UncacheTest)
{
    nn::Result result;
    TestResourceEnv resourceEnv;
    uintptr_t addr = reinterpret_cast<uintptr_t>(g_Buffer);
    size_t size = 0x1000;
    nn::Bit32 attribute = nn::svc::MemoryAttribute_Uncached;
    nn::Bit32 mask = nn::svc::MemoryAttribute_Uncached;
    int64_t cacheTime = 0;
    int64_t uncacheTime = 0;
    uint32_t loopNum = 0x10000;

    {
        volatile int64_t begin = nn::svc::GetSystemTick();
        for (uint32_t i = 1; i < loopNum; i++)
        {
            g_Buffer[0] = static_cast<char>(i);
            g_Buffer[1] = g_Buffer[0];
        }
        volatile int64_t end = nn::svc::GetSystemTick();
        cacheTime = end - begin;
    }

    result = nn::svc::SetMemoryAttribute(addr, size, mask, attribute);
    ASSERT_RESULT_SUCCESS(result);

    {
        volatile int64_t begin = nn::svc::GetSystemTick();
        for (uint32_t i = 1; i < loopNum; i++)
        {
            g_Buffer[0] = static_cast<char>(i);
            g_Buffer[1] = g_Buffer[0];
        }
        volatile int64_t end = nn::svc::GetSystemTick();
        uncacheTime = end - begin;
    }

    result = nn::svc::SetMemoryAttribute(addr, size, mask, 0);
    ASSERT_RESULT_SUCCESS(result);

    NN_LOG("cache: 0x%llx\n", cacheTime);
    NN_LOG("uncache: 0x%llx\n", uncacheTime);

    // JUNO-A53 だけ挙動が違うため、テストから外す
#if !(defined(NN_BUILD_CONFIG_HARDWARE_JUNO) && defined NN_BUILD_CONFIG_CPU_CORTEX_A53)
    ASSERT_TRUE(cacheTime * 2 < uncacheTime);
#endif
}

