﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/TargetConfigs/build_Fpu.h>
#include <nn/svc/svc_BaseId.autogen.h>
#include <nn/svc/svc_ServerId.autogen.h>
#include <nn/svc/svc_TcbId.autogen.h>

#if defined NN_BUILD_CONFIG_CPU_ARM64
    .section .text, "ax"
    .align   2
    .global  CheckReturnRegisters
    .type    CheckReturnRegisters, %function
CheckReturnRegisters:
    cmp     x0,  #0
    b.ne    1f
    mov     x0,  sp
    mov     x1,  #1
    mov     x2,  #2
    mov     x3,  #3
    mov     x4,  #4
    mov     x5,  #5
    mov     x6,  #6
    mov     x7,  #7
    mov     x8,  #8
    mov     x9,  #9
    mov     x10, #10
    mov     x11, #11
    mov     x12, #12
    mov     x13, #13
    mov     x14, #14
    mov     x15, #15
    mov     x16, #16
    mov     x17, #17
    mov     x18, #18
    mov     x19, #19
    mov     x20, #20
    mov     x21, #21
    mov     x22, #22
    mov     x23, #23
    mov     x24, #24
    mov     x25, #25
    mov     x26, #26
    mov     x27, #27
    mov     x28, #28
    mov     x29, #29
    mov     x30, #30

    ldr     x3, [x3]
    b       2f

    // x2 だけは確認しない
    mrs     x2,  nzcv
    cmp     x2,  #0
    b.ne    2f
    cmp     x1,  #1
    b.ne    2f
    mov     x1,  sp
    cmp     x0,  x1
    b.ne    2f
    cmp     x3,  #3
    b.ne    2f
    cmp     x4,  #4
    b.ne    2f
    cmp     x5,  #5
    b.ne    2f
    cmp     x6,  #6
    b.ne    2f
    cmp     x7,  #7
    b.ne    2f
    cmp     x8,  #8
    b.ne    2f
    cmp     x9,  #0
    b.ne    2f
    cmp     x10, #0
    b.ne    2f
    cmp     x11, #0
    b.ne    2f
    cmp     x12, #0
    b.ne    2f
    cmp     x13, #0
    b.ne    2f
    cmp     x14, #0
    b.ne    2f
    cmp     x15, #0
    b.ne    2f
    cmp     x16, #0
    b.ne    2f
    cmp     x17, #0
    b.ne    2f
    cmp     x18, #0
    b.ne    2f
    cmp     x19, #0
    b.ne    2f
    cmp     x20, #0
    b.ne    2f
    cmp     x21, #0
    b.ne    2f
    cmp     x22, #0
    b.ne    2f
    cmp     x23, #0
    b.ne    2f
    cmp     x24, #0
    b.ne    2f
    cmp     x25, #0
    b.ne    2f
    cmp     x26, #0
    b.ne    2f
    cmp     x27, #0
    b.ne    2f
    cmp     x28, #0
    b.ne    2f
    cmp     x29, #0
    b.ne    2f
    cmp     x30, #30
    b.ne    2f

    svc     #NN_SVC_ID_EXIT_PROCESS
1:
    mov x4, #101
    cmp x0, x4
    // PC の書き換え
    ldr x5, [x1, #88]
    add x5, x5, #8
    str x5, [x1, #88]
    // PSTATE の書き換え
    ldr x5, [x1, #96]
    mov x5, #0
    str x5, [x1, #96]
    mov     x0,  #0
    mov     x1,  #0
    mov     x2,  #0
    mov     x3,  #0
    mov     x4,  #0
    mov     x5,  #0
    mov     x6,  #0
    mov     x7,  #0
    mov     x8,  #0
    mov     x9,  #0
    mov     x10, #0
    mov     x11, #0
    mov     x12, #0
    mov     x13, #0
    mov     x14, #0
    mov     x15, #0
    mov     x16, #0
    mov     x17, #0
    mov     x18, #0
    mov     x19, #0
    mov     x20, #0
    mov     x21, #0
    mov     x22, #0
    mov     x23, #0
    mov     x24, #0
    mov     x25, #0
    mov     x26, #0
    mov     x27, #0
    mov     x28, #0
    mov     x29, #0
    mov     x30, #0
    cmp     x30, x29 // pstate を更新
    svc     #NN_SVC_ID_RETURN_FROM_EXCEPTION

2:  b 2b
    .size   CheckReturnRegisters, [. - CheckReturnRegisters]

#else

    .section .text, "ax"
    .align   2
    .global  CheckReturnRegisters
    .type    CheckReturnRegisters, %function
CheckReturnRegisters:
    cmp     r0,  #0
    bne     1f
    mov     r0,  sp
    mov     r1,  #1
    mov     r2,  #2
    mov     r3,  #3
    mov     r4,  #4
    mov     r5,  #5
    mov     r6,  #6
    mov     r7,  #7
    mov     r8,  #8
    mov     r9,  #9
    mov     r10, #10
    mov     r11, #11
    mov     r12, #12
    mov     r14, #14

    ldr     r3, [r3]
    b       2f

    // r2 だけは確認しない
    mrs     r2,  cpsr
    cmp     r2,  #0x10 // user mode
    bne     2f
    cmp     r0,  sp
    bne     2f
    cmp     r1,  #1
    bne     2f
    cmp     r3,  #3
    bne     2f
    cmp     r4,  #4
    bne     2f
    cmp     r5,  #5
    bne     2f
    cmp     r6,  #6
    bne     2f
    cmp     r7,  #7
    bne     2f
    cmp     r8,  #0
    bne     2f
    cmp     r9,  #0
    bne     2f
    cmp     r10, #0
    bne     2f
    cmp     r11, #0
    bne     2f
    cmp     r12, #0
    bne     2f
    cmp     r14, #14
    bne     2f

    svc     #NN_SVC_ID_EXIT_PROCESS
1:
    mov     r4, #101
    cmp     r0, r4
    // PC の更新
    ldr     r5, [r1, #40]
    add     r5, r5, #8
    str     r5, [r1, #40]
    // PSTATE の書き換え
    ldr     r5, [r1, #48]
    mov     r5, #0x10 // user mode
    str     r5, [r1, #48]
    mov     r0,  #0
    mov     r1,  #0
    mov     r2,  #0
    mov     r3,  #0
    mov     r4,  #0
    mov     r5,  #0
    mov     r6,  #0
    mov     r7,  #0
    mov     r8,  #0
    mov     r9,  #0
    mov     r10, #0
    mov     r11, #0
    mov     r12, #0
    mov     r13, #0 // sp
    mov     r14, #0 // LR
    cmp     r13, r14 // pstate を更新
    svc     #NN_SVC_ID_RETURN_FROM_EXCEPTION

2:  b 2b
    .size   CheckReturnRegisters, [. - CheckReturnRegisters]

#endif

