﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "util_DebugProcess.h"
#include "util_TestIpc.h"
#include "util_TestProcess.h"
#include <cstring>

#ifdef ENABLE_LEAK_TEST
namespace {

struct ResourceLeakTestData
{
    int32_t memoryBlock;
    int32_t event;
    int32_t interruptEvent;
    int32_t thread;
    int32_t sharedMemory;
    int32_t transferMemory;
    int32_t deviceAddressSpace;
    int32_t session;
    int32_t process;
    int32_t port;
    int32_t dma;
    int32_t debug;
    int32_t namedPort;
    int32_t lightSession;
};

void StoreResources(ResourceLeakTestData* data)
{
    {
        ConsumeMemoryControlBlock memoryBlock;
        data->memoryBlock = memoryBlock.GetCount();
    }

    {
        ConsumeEvent event;
        data->event = event.GetCount();
    }

    {
        ConsumeInterruptEvent interruptEvent;
        data->interruptEvent = interruptEvent.GetCount();
    }

    {
        ConsumeThread thread;
        data->thread = thread.GetCount();
    }

    {
        ConsumeSharedMemory sharedMemory;
        data->sharedMemory = sharedMemory.GetCount();
    }

    {
        ConsumeTransferMemory transferMemory;
        data->transferMemory = transferMemory.GetCount();
    }

    {
        ConsumeDeviceAddressSpace deviceAddressSpace;
        data->deviceAddressSpace = deviceAddressSpace.GetCount();
    }

    {
        ConsumeSession session;
        data->session = session.GetCount();
    }

    {
        ConsumeProcess process;
        data->process = process.GetCount();
    }

    {
        ConsumePort port;
        data->port = port.GetCount();
    }

    {
        ConsumeDma dma;
        data->dma = dma.GetCount();
    }

    {
        ConsumeDebug debug;
        data->debug = debug.GetCount();
    }

    {
        ConsumeNamedPort namedPort;
        data->namedPort = namedPort.GetCount();
    }

    {
        ConsumeLightSession lightSession;
        data->lightSession = lightSession.GetCount();
    }
}

void CheckResourceLeak(ResourceLeakTestData* expect, ResourceLeakTestData* actual)
{
    NN_LOG("### Start ResourceLeak Test ###\n");

    ASSERT_EQ(expect->memoryBlock, actual->memoryBlock);
    ASSERT_EQ(expect->event, actual->event);
    ASSERT_EQ(expect->interruptEvent, actual->interruptEvent);
    ASSERT_EQ(expect->thread, actual->thread);
    ASSERT_EQ(expect->sharedMemory, actual->sharedMemory);
    ASSERT_EQ(expect->transferMemory, actual->transferMemory);
    ASSERT_EQ(expect->deviceAddressSpace, actual->deviceAddressSpace);
    ASSERT_EQ(expect->session, actual->session);
    ASSERT_EQ(expect->process, actual->process);
    ASSERT_EQ(expect->port, actual->port);
    ASSERT_EQ(expect->dma, actual->dma);
    ASSERT_EQ(expect->debug, actual->debug);
    ASSERT_EQ(expect->namedPort, actual->namedPort);
    ASSERT_EQ(expect->lightSession, actual->lightSession);

    NN_LOG("### Finish ResourceLeak Test ###\n");
}

ResourceLeakTestData g_ResourceData = { 0 };
uint64_t g_LoopCount = 0;

} // namespace

TEST(ResourceTest, ResourceLeak)
{
    if (g_LoopCount == 1)
    {
        StoreResources(&g_ResourceData);
    }
    else if (g_LoopCount > 1)
    {
        ResourceLeakTestData data = { 0 };
        StoreResources(&data);
        CheckResourceLeak(&g_ResourceData, &data);
    }

    g_LoopCount++;
}

#endif // ENABLE_LEAK_TEST

