﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Compiler.h>
#include "test_Common.h"
#include <nn/svc/svc_Dd.h>

namespace {
}
extern "C" void nnMain();

#if defined NN_BUILD_CONFIG_COMPILER_CLANG
#pragma clang diagnostic ignored "-Wtautological-compare"
#endif

TEST(QueryPhysicalAddress, NormalTest)
{
    uintptr_t addr;
    size_t size;
    nn::Result result;
    nn::svc::MemoryInfo blockInfo;
    nn::svc::PageInfo pageInfo;

    size = HeapAlign;
    result = nn::svc::SetHeapSize(&addr, size);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 82-7 から 82-22
    // メモリ状態とパーミッションのチェック
    // 全アドレス空間を4Kごとにチェック
    uintptr_t v = CheckVirtualBegin;
    do
    {
        nn::svc::PhysicalMemoryInfo physInfo = { 0 };
        result = nn::svc::QueryMemory(&blockInfo, &pageInfo, v);
        if (ProcessBegin <= v && v <= ProcessEnd)
        {
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::QueryPhysicalAddress(&physInfo, v);
            switch (blockInfo.state)
            {
                case nn::svc::MemoryState_Static:
                case nn::svc::MemoryState_Code:
                case nn::svc::MemoryState_CodeData:
                case nn::svc::MemoryState_Normal:
                case nn::svc::MemoryState_Alias:
                case nn::svc::MemoryState_AliasCode:
                case nn::svc::MemoryState_AliasCodeData:
                case nn::svc::MemoryState_Ipc:
                case nn::svc::MemoryState_Stack:
                case nn::svc::MemoryState_Transfered:
                    {
                        if (blockInfo.permission == nn::svc::MemoryPermission_ReadExecute || blockInfo.permission == nn::svc::MemoryPermission_None)
                        {
                            ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());
                        }
                        else
                        {
                            ASSERT_RESULT_SUCCESS(result);
                            if (blockInfo.state != nn::svc::MemoryState_Io && blockInfo.state != nn::svc::MemoryState_Static)
                            {
                                ASSERT_TRUE(PhysMemoryBegin <= physInfo.physicalAddress && physInfo.physicalAddress + physInfo.size - 1 <= PhysMemoryEnd - 1);
                            }
                        }
                    }
                    break;
                default:
                    {
                        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());
                    }
                    break;
            }
        }
        else
        {
            ASSERT_RESULT_SUCCESS(result);
            ASSERT_TRUE(blockInfo.baseAddress == ProcessEnd + 1);
            ASSERT_TRUE(blockInfo.size == (0 - (ProcessEnd + ProcessBegin + 1)));
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Inaccessible);
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
        }
        v += 0x1000;
    } while (v != CheckVirtualEnd);

    result = nn::svc::SetHeapSize(&addr, 0);
    ASSERT_RESULT_SUCCESS(result);
}

