﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_TestIoMapping.h"
#include "test_QueryIoMapping.h"
#include "test_Common.h"
#include <nn/svc/ipc/svc_SessionMessage.h>
#include <nn/init.h>

extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

namespace {
} // namespace

uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

extern "C" void nnMain()
{
    InitTestMemory();

    nn::Result result;
    uintptr_t addr;

    nn::svc::Handle clientSession;
    result = nn::svc::ConnectToNamedPort(&clientSession, PortName);
    if (result.IsFailure())
    {
        NN_LOG("Test has been already closed\n");
        return;
    }
    NN_ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose cSessionCloser(clientSession);

    nn::Bit32* pMsgBuffer = nn::svc::ipc::GetMessageBuffer();
    nn::svc::ipc::MessageBuffer ipcMsg(pMsgBuffer);

    // サーバーに接続
    {
        ipcMsg.Set(
            nn::svc::ipc::MessageBuffer::MessageHeader(
                0x0001, 0, 0, 0, 0, 0, 0, 0));
        result = nn::svc::SendSyncRequest(clientSession);
        if (result <= nn::svc::ResultSessionClosed())
        {
            return;
        }
        NN_ASSERT_RESULT_SUCCESS(result);
    }

    // 受信
    nn::svc::PhysicalAddress phyAddr = 0;
    uint32_t mapSize = 0;
    bool isReadWrite = false;
    {
        nn::svc::ipc::MessageBuffer ipcMsg(pMsgBuffer);
        nn::svc::ipc::MessageBuffer::MessageHeader ipcHeader(ipcMsg);
        nn::svc::ipc::MessageBuffer::SpecialHeader ipcSpecial(ipcMsg, ipcHeader);

        NN_ASSERT(ipcHeader.GetTag() == 0x0002);

        int offset = nn::svc::ipc::MessageBuffer::GetRawDataOffset(ipcHeader, ipcSpecial);
        phyAddr = static_cast<uint64_t>(pMsgBuffer[offset]) << 32
                    | static_cast<uint64_t>(pMsgBuffer[offset + 1]);
        mapSize = static_cast<uint64_t>(pMsgBuffer[offset + 2]);
        isReadWrite = pMsgBuffer[offset + 3] != 0;
    }

    size_t size = 0x1000;
    uintptr_t topAddr;
    nn::svc::MemoryInfo blockInfo;
    nn::svc::MemoryPermission correctPermission = isReadWrite ?
        nn::svc::MemoryPermission_ReadWrite : nn::svc::MemoryPermission_Read;

    result = nn::svc::QueryIoMapping(&addr, phyAddr, mapSize);
    NN_ASSERT_RESULT_SUCCESS(result);
    topAddr = addr;

    GetMemoryInfo(&blockInfo, addr);
    NN_ASSERT(blockInfo.state == nn::svc::MemoryState_Io);
    NN_ASSERT(blockInfo.permission == correctPermission);

    result = nn::svc::QueryIoMapping(&addr, phyAddr - size, size);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultNotFound());

    result = nn::svc::QueryIoMapping(&addr, phyAddr - size, size * 2);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultNotFound());

    result = nn::svc::QueryIoMapping(&addr, phyAddr + mapSize - size, size * 2);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultNotFound());

    for (uintptr_t i = 0; i < mapSize; i += size)
    {
        result = nn::svc::QueryIoMapping(&addr, phyAddr + i, size);
        NN_ASSERT_RESULT_SUCCESS(result);
        NN_ASSERT(addr - topAddr == i);

        GetMemoryInfo(&blockInfo, addr);
        NN_ASSERT(blockInfo.state == nn::svc::MemoryState_Io);
        NN_ASSERT(blockInfo.permission == correctPermission);
    }

    for (size = 0x1000; size <= mapSize; size += 0x1000)
    {
        result = nn::svc::QueryIoMapping(&addr, phyAddr, size);
        NN_ASSERT_RESULT_SUCCESS(result);
        NN_ASSERT(addr == topAddr);

        GetMemoryInfo(&blockInfo, addr);
        NN_ASSERT(blockInfo.state == nn::svc::MemoryState_Io);
        NN_ASSERT(blockInfo.permission == correctPermission);

        result = nn::svc::QueryIoMapping(&addr, phyAddr + (mapSize - size), size);
        NN_ASSERT_RESULT_SUCCESS(result);
        NN_ASSERT((addr - topAddr) == (mapSize - size));

        GetMemoryInfo(&blockInfo, addr);
        NN_ASSERT(blockInfo.state == nn::svc::MemoryState_Io);
        NN_ASSERT(blockInfo.permission == correctPermission);
    }

    result = nn::svc::QueryIoMapping(&addr, phyAddr, mapSize + 1);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultNotFound());

    result = nn::svc::QueryIoMapping(&addr, phyAddr + mapSize, 1);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultNotFound());
}

