﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Thread.h>
#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Tcb.h>
#include <nnt/teamcity/testTeamcity_Logger.h>
#include <nn/os/os_UserExceptionHandler.h>
#include <nn/os.h>
#include <nn/init.h>
#include <cstring>
#include <nnt/nnt_Argument.h>
#include <nn/nn_Abort.h>

#ifdef DISABLE_LOG_MANAGER
extern "C" void nndiagStartup()
{
}
#endif // DISABLE_LOG_MANAGER

extern "C" void nninitStartup()
{
    // ResourceLimit の制限を受けないための Hack
    nn::Result result;
    nn::Bit64 v;
    int64_t value;

    result = nn::svc::GetInfo(&v, nn::svc::InfoType_ResourceLimit, nn::svc::Handle(0), 0);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    nn::svc::Handle handle(v);

    result = nn::svc::GetResourceLimitLimitValue(&value, handle, nn::svc::LimitableResource_PhysicalMemoryMax);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    result = nn::svc::SetResourceLimitLimitValue(handle, nn::svc::LimitableResource_PhysicalMemoryMax, value * 2);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    result = nn::svc::GetResourceLimitLimitValue(&value, handle, nn::svc::LimitableResource_ThreadCountMax);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    result = nn::svc::SetResourceLimitLimitValue(handle, nn::svc::LimitableResource_ThreadCountMax, value * 2);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    result = nn::svc::GetResourceLimitLimitValue(&value, handle, nn::svc::LimitableResource_EventCountMax);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    result = nn::svc::SetResourceLimitLimitValue(handle, nn::svc::LimitableResource_EventCountMax, value * 2);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    result = nn::svc::GetResourceLimitLimitValue(&value, handle, nn::svc::LimitableResource_TransferMemoryCountMax);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    result = nn::svc::SetResourceLimitLimitValue(handle, nn::svc::LimitableResource_TransferMemoryCountMax, value * 2);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    result = nn::svc::GetResourceLimitLimitValue(&value, handle, nn::svc::LimitableResource_SessionCountMax);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    result = nn::svc::SetResourceLimitLimitValue(handle, nn::svc::LimitableResource_SessionCountMax, value * 2);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    nn::svc::CloseHandle(handle);
}

int32_t g_ProcessIdealCore;
uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

extern "C" void nnMain()
{
#ifdef TEST_INFINIT_LOOP
    const char* RepeatString = "--gtest_repeat=-1";
    char repeatStringBuf[30];
    std::strcpy(repeatStringBuf, RepeatString);
    int argc = 2;
    char* argv[2] = { repeatStringBuf, repeatStringBuf };
#else
    int    argc = nnt::GetHostArgc();
    char** argv = nnt::GetHostArgv();
#endif
    ::testing::InitGoogleTest(&argc, argv);

    nn::os::SetUserExceptionHandler(nullptr, nullptr, 0, nullptr);

    // TeamCity の表示を適切にするため、イベントリスナの登録を一旦すべて解除し、
    // ServiceMessageLogger -> デフォルトのイベントリスナ の順で登録し直す。
    ::testing::TestEventListeners& listeners = ::testing::UnitTest::GetInstance()->listeners();
    ::testing::TestEventListener* defaultResultPrinter = listeners.Release(listeners.default_result_printer());
    listeners.Append(new nnt::teamcity::ServiceMessageLogger());
    listeners.Append(defaultResultPrinter);

    // テストで使うデータの準備
    {
        // カレントコアの取得
        nn::Bit64 mask;
        nn::Result result = nn::svc::GetThreadCoreMask(&g_ProcessIdealCore, &mask, static_cast<nn::svc::Handle>(nn::svc::PSEUDO_HANDLE_CURRENT_THREAD));
        if (result.IsFailure())
        {
            return;
        }
        if (nn::svc::GetCurrentProcessorNumber() != g_ProcessIdealCore)
        {
            return;
        }

        InitTestMemory();
    }

    RUN_ALL_TESTS();
}
